/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.analytics.util.EUTMExternal;
import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.favorites.EFavoriteObservedOperation;
import de.maggicraft.ism.favorites.IFavorite;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.local.MLocal;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.mapper.EDirection;
import de.maggicraft.ism.mapper.EMirror;
import de.maggicraft.ism.storage.IStorageCreator;
import de.maggicraft.ism.storage.IStorageProjectBase;
import de.maggicraft.ism.storage.IStorageStructure;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.ism.str.BoundingBoxButton;
import de.maggicraft.ism.str.IReadableStructure;
import de.maggicraft.ism.str.StrUtil;
import de.maggicraft.ism.views.IViewDeinit;
import de.maggicraft.ism.views.IViewPos;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.ism.world.util.Pos;
import de.maggicraft.mcommons.event.IObserver;
import de.maggicraft.mcommons.filter.types.MFilters;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mcommons.util.MTriple;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MPictureMode;
import de.maggicraft.mgui.comp.MSwitcher;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.comp.MToggle;
import de.maggicraft.mgui.filter.check.MChecker;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.settings.MSettingGui;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MViewPlaceStructure
extends MISMView<Integer>
implements IViewPos,
IViewDeinit {
    public static final int MODE_PLACED = 1;
    private static final String[] ROT = MLangManager.get("st", "sth", "wst", "nrth");
    @Nullable
    private IReadableStructure mSchematic;
    @Nullable
    private IPos mPos;
    private Runnable mAfterDisplay;
    private MField mFieldPosX;
    private MField mFieldPosY;
    private MField mFieldPosZ;
    private MCombo mComboRot;
    @Nullable
    private IObserver<IFavorite> mObserverAdded;
    @Nullable
    private IObserver<IFavorite> mObserverRemoved;
    private int mRot;
    private int mThirdX;
    private int mThirdY;
    private int mThirdZ;
    private int mMode;

    private static int forecastHeight(int pHeight, int pCornerY, boolean pContainBedrock) {
        int lowerOffset;
        int n = lowerOffset = pContainBedrock ? 1 : 0;
        if (pCornerY >= lowerOffset && pHeight + pCornerY < 256) {
            return pHeight;
        }
        int offsetLow = pCornerY < lowerOffset ? pCornerY * -1 + lowerOffset : 0;
        int offsetHigh = 0;
        if (pHeight + pCornerY > 255) {
            offsetHigh = (256 - (pCornerY + pHeight)) * -1;
            if (offsetLow > 0) {
                ++offsetHigh;
            }
        }
        return pHeight - offsetLow - offsetHigh;
    }

    @Override
    protected void displayState(Integer pMode) {
        if (!ISMContainer.getUpdateManager().isLegal()) {
            return;
        }
        if (this.mSchematic != null) {
            this.mMode = pMode;
        }
        if (this.mSchematic == null || ViewUtil.isLogoutShown()) {
            ViewUtil.titleTutorial(this, "plcStr", EUTMView.VIEW_PLACE_STRUCTURE);
        }
        if (this.mSchematic == null) {
            if (pMode == 1) {
                this.mMode = 1;
            }
            int width = this.viewNoStr(this.mMode == 1);
            this.mAfterDisplay = () -> this.setDim(width, 340);
        } else if (ISMContainer.getWorldInfoManager().isLoggedOut()) {
            int width = this.viewLoggedOut();
            this.mAfterDisplay = () -> this.setDim(width, 120);
        } else {
            IComp last = this.viewPlcStr();
            this.mAfterDisplay = () -> this.setDim(last, 660);
        }
    }

    @NotNull
    private IComp viewPlcStr() {
        this.mThirdX = 0;
        this.mThirdY = 0;
        this.mThirdZ = 0;
        this.mRot = ISMContainer.getWorldInfoManager().getRot();
        this.mPos = ISMContainer.getWorldInfoManager().getPlayerPos();
        IDim dim = Objects.requireNonNull(this.mSchematic).getDim();
        int dimX = dim.getX();
        int dimY = dim.getX();
        int dimZ = dim.getX();
        MPanel panelInfo = this.mSchematic instanceof IStorageStructure ? this.panelStr() : this.panelLocal();
        MFlowPanel headerPosOri = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)panelInfo, 1), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerPosOri, "[[m,]]<>p<>")).title("posOr");
        MPanel panelPosOri = new MPanel(MPos.pos("V[[<30>M455<75>,[]<85>505", panelInfo), MCon.colorFrame());
        int wid = CommonUtil.getMax(Util.getWidth(MCon.fontCombo(), ROT) + 45, Util.getWidth(MCon.fontCombo(), ""), 70, Util.getWidth(MCon.fontButton(), "info") + 50);
        String std = "V]]<>" + wid + "<>,[]30";
        MButton bInfo = new MButton((MMPos)MPos.pos(panelPosOri, "]]" + wid + "<>,[[<>30"), null).title("infoPlc", new MTip());
        int initX = this.mPos.getX();
        int initY = this.mPos.getY();
        if (initY < 1) {
            initY = 1;
        } else if (initY + dimY > 255) {
            initY = 255 - dimY;
        }
        int initZ = this.mPos.getZ();
        this.mFieldPosX = new MField(MPos.pos(std, bInfo)).text(Integer.toString(initX)).name("fX");
        this.mFieldPosY = new MField(MPos.pos(std, this.mFieldPosX)).text(Integer.toString(initY)).name("fY");
        this.mFieldPosZ = new MField(MPos.pos(std, this.mFieldPosY)).text(Integer.toString(initZ)).name("fZ");
        MChecker checker = new MChecker();
        checker.add(MFilters.filterInt(-dimY + 1, 255), true, this.mFieldPosY);
        checker.add(ViewUtil.WORLD_SIZE, true, this.mFieldPosX, this.mFieldPosZ);
        this.mPos = ViewUtil.checkPos(this.mPos);
        this.mComboRot = new MCombo(MPos.pos(std, this.mFieldPosZ)).text(ROT);
        this.mComboRot.setSelectedIndex(this.mRot);
        this.mComboRot.setEnabled(false);
        ImageIcon iconXZ = ImgUtil.getAppIcon("sp_xz_" + this.mThirdX + '_' + this.mThirdZ);
        final MButton buttonXZ = new MButton((MMPos)MPos.pos("]]65<>,[]65", this.mComboRot), (Icon)iconXZ);
        buttonXZ.setEnabled(false);
        final MButton buttonY = new MButton((MMPos)MPos.pos("]]23<>,[]65", buttonXZ), (Icon)ImgUtil.getAppIcon("sp_y_" + this.mThirdY));
        buttonY.setEnabled(false);
        MPicture picXZAxes = new MPicture(MPicPos.pos("][p,||p", buttonXZ), ImgUtil.getAppIcon("xz_axes_" + this.mComboRot.getSelectedIndex()), MPictureMode.CUT);
        new MPicture(MPicPos.pos("][p,||p", buttonY), ImgUtil.getAppIcon("y_axis"), MPictureMode.CUT);
        MSwitcher swMirrorX = new MSwitcher(MPos.pos("V]]p<>,[]30", buttonY), false);
        MSwitcher swMirrorY = new MSwitcher(MPos.pos("V]]p<>,[]30", swMirrorX), false);
        MSwitcher swMirrorZ = new MSwitcher(MPos.pos("V]]p<>,[]30<>", swMirrorY), false);
        swMirrorX.setEnabled(false);
        swMirrorY.setEnabled(false);
        swMirrorZ.setEnabled(false);
        new MText(MPos.pos("V[[<>p,||<>p", bInfo)).title("plcAt");
        new MText(MPos.pos("V[[<>p,||p", this.mFieldPosX)).title("posX");
        new MText(MPos.pos("V[[<>p,||p", this.mFieldPosY)).title("posY");
        new MText(MPos.pos("V[[<>p,||p", this.mFieldPosZ)).title("posZ");
        new MText(MPos.pos("V[[<>p,||p", this.mComboRot)).title("rot");
        MText tePlayerPos = new MText(MPos.pos("V[[<>p,[[<>p", buttonXZ)).title("playerPos");
        new MPicture(MPicPos.pos("[]<5>p<2>,||<5>p<>", tePlayerPos), ImgUtil.getAppIcon("player"), MPictureMode.CUT);
        new MText(MPos.pos("V[[<>p,||p", swMirrorX)).rep("mir", "x");
        new MText(MPos.pos("V[[<>p,||p", swMirrorY)).rep("mir", "y");
        new MText(MPos.pos("V[[<>p,||p<>", swMirrorZ)).rep("mir", "z");
        MFlowPanel headerOther = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)panelPosOri, 2), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerOther, "[[m,]]<>p<>")).title("oth");
        MPanel panelOther = new MPanel(MPos.pos("V[[<30>M455<30>,[]<85>75", panelPosOri), MCon.colorFrame());
        MSwitcher swFlatten = MSettingGui.switcherBool(CSettings.SETTING_FLATTEN_AREA, MPos.pos(panelOther, "]]p<>,[[<>30"), "");
        final BoundingBoxButton bbButton = new BoundingBoxButton(MPos.pos("V]]p<>,[]30<>", swFlatten), dimY);
        this.mComboRot.addItemListener(pEvent -> {
            int index = this.mComboRot.getSelectedIndex();
            picXZAxes.setIcon(ImgUtil.getAppIcon("xz_axes_" + index));
            bbButton.setNext(this.getConvertPosDim());
        });
        buttonXZ.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent pEvent) {
                MViewPlaceStructure.this.mThirdX = 2 - ViewUtil.getThird(pEvent.getY());
                MViewPlaceStructure.this.mThirdZ = ViewUtil.getThird(pEvent.getX());
                buttonXZ.setIcon(ImgUtil.getAppIcon("sp_xz_" + MViewPlaceStructure.this.mThirdX + '_' + MViewPlaceStructure.this.mThirdZ));
                bbButton.setNext(MViewPlaceStructure.this.getConvertPosDim());
            }
        });
        buttonY.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent pEvent) {
                MViewPlaceStructure.this.mThirdY = 2 - ViewUtil.getThird(pEvent.getY());
                buttonY.setIcon(ImgUtil.getAppIcon("sp_y_" + MViewPlaceStructure.this.mThirdY));
                bbButton.setNext(MViewPlaceStructure.this.getConvertPosDim());
            }
        });
        this.mFieldPosX.addListener(pEvent -> {
            if (!this.mFieldPosX.getText().isEmpty()) {
                checker.check();
            }
            if (MFilters.FILTER_INTEGER.isValid(this.mFieldPosX.getText())) {
                bbButton.setNext(this.getConvertPosDim());
            }
        });
        this.mFieldPosY.addListener(pEvent -> {
            if (!this.mFieldPosY.getText().isEmpty()) {
                checker.check();
            }
            if (MFilters.FILTER_INTEGER.isValid(this.mFieldPosY.getText())) {
                bbButton.setNext(this.getConvertPosDim());
            }
        });
        this.mFieldPosZ.addListener(pEvent -> {
            if (!this.mFieldPosZ.getText().isEmpty()) {
                checker.check();
            }
            if (MFilters.FILTER_INTEGER.isValid(this.mFieldPosZ.getText())) {
                bbButton.setNext(this.getConvertPosDim());
            }
        });
        bbButton.setNext(this.getConvertPosDim());
        new MText(MPos.pos("V[[<>p,||<>p", swFlatten)).title("fltArea");
        MText last = new MText(MPos.pos("V[[<30>455<40>,[]p<75>", panelOther)).title("infoProgress");
        new MButton(MPos.pos(this, "[[<30>p,]]s<25>")).addAction(pEvent -> {
            ISMContainer.getBoundingBox().remove();
            this.mSchematic = null;
            ViewManager.displayLeftMenu(this);
        }).title("cancel");
        new MButton(MPos.pos(this, "]]p<30>,]]s<25>")).addAction(pEvent -> new Thread(() -> {
            if (!checker.check()) {
                return;
            }
            String url = this.mSchematic instanceof IStorageStructure ? ((IStorageStructure)this.mSchematic).getProject().getURL() : "local:" + ((MLocal)this.mSchematic).getFileName();
            Pos corner = new Pos(this.mFieldPosX.getInt(), this.mFieldPosY.getInt(), this.mFieldPosZ.getInt());
            try {
                ISMContainer.getPlaceStructure().placeStructure(this.mSchematic.getFile(), corner, EDirection.POS_X_POS_Z, EMirror.NO_MIRROR, swFlatten.isSelected(), url);
            }
            catch (StorageException pE) {
                this.mSchematic = null;
                StorageUtil.handleStorageException(pE);
                ISMContainer.getViewManager().displayFrame(EView.VIEW_BROWSE);
            }
        }).start()).title("plcStr");
        return last;
    }

    @NotNull
    private MPanel panelStr() {
        if (this.mSchematic == null) {
            throw new NullPointerException();
        }
        if (this.mObserverAdded != null) {
            ISMContainer.getFavoritesManager().removeObserver(EFavoriteObservedOperation.FAVORITE_REMOVED, this.mObserverAdded);
        }
        if (this.mObserverRemoved != null) {
            ISMContainer.getFavoritesManager().removeObserver(EFavoriteObservedOperation.FAVORITE_ADDED, this.mObserverRemoved);
        }
        MPanel panel = new MPanel(MPos.pos(this, "||<30>m<30>,[[<>486<>"), MCon.colorFrame());
        IStorageStructure str = (IStorageStructure)this.mSchematic;
        IStorageProjectBase project = str.getProject();
        IProject dataProject = project.toProject();
        ICreator dataCreator = dataProject.getCreator();
        IStorageCreator creator = project.getCreator();
        this.mainHeader(str.getName(), dataProject, dataCreator);
        MButton thumb = ViewUtil.thumbnailButton(MPos.pos(panel, "[[256,[[<76>150"), dataProject);
        MTriple<MToggle, IObserver<IFavorite>, IObserver<IFavorite>> bFav = ViewUtil.buttonFav(MPos.pos("[]<30>p,[[<>p", thumb), dataProject);
        this.mObserverAdded = bFav.getB();
        this.mObserverRemoved = bFav.getC();
        MButton bProject = ViewUtil.buttonProject(MPos.pos("[]<30>p,[[<>p", bFav.getA()), dataProject, EUTMExternal.EXT_PLACE_STR);
        ViewUtil.buttonCre(MPos.pos("[]<30>p,[[<>p", bProject), creator.toCreator(), EUTMExternal.EXT_PLACE_STR);
        int w = Util.getWidth(MCon.fontText(), MLangManager.prefix("te.", "proj", "plce", "cre", "blks", "wid", "hig", "len", "difBlks")) + MCon.defaultGap();
        String posLeft = "[[<>" + w + ",[]<8>p<>";
        MText tStr = new MText(MPos.pos("[[<>" + w + ",[]<25>p", thumb)).title("str");
        MText tCre = new MText(MPos.pos(posLeft, tStr)).title("cre");
        MText tAdd = new MText(MPos.pos(posLeft, tCre)).title("added");
        MText tPlc = new MText(MPos.pos(posLeft, tAdd)).title("plce");
        MText tWid = new MText(MPos.pos(posLeft, tPlc)).title("wid");
        MText tHig = new MText(MPos.pos(posLeft, tWid)).title("hig");
        MText tLen = new MText(MPos.pos(posLeft, tHig)).title("len");
        MText tBlk = new MText(MPos.pos(posLeft, tLen)).title("blks");
        MText tName = ViewUtil.addInfo(tStr, str.getName());
        SharedUtil.addLink(tName, () -> ViewManager.displayDetail(dataProject));
        MText tCreName = ViewUtil.addInfo(tCre, creator.getName());
        SharedUtil.addLink(tCreName, () -> ViewManager.displayDetail(dataCreator));
        ViewUtil.addInfo(tAdd, SharedUtil.formatDate(project.getDateAdded()));
        ViewUtil.addInfo(tPlc, str.getPlaced() == 1 ? MLangManager.get("te.time") : MLangManager.rep("te.times", str.getPlaced()));
        IDim dim = this.mSchematic.getDim();
        ViewUtil.addInfo(tWid, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getX())));
        ViewUtil.addInfo(tHig, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getY())));
        ViewUtil.addInfo(tLen, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getZ())));
        ViewUtil.addInfo(tBlk, CommonUtil.decMark(str.getBlocks()));
        return panel;
    }

    private void mainHeader(@NotNull String pName, IProject pProject, @NotNull ICreator pCreator) {
        MFlowPanel header = new MFlowPanel((MMPos)LPos.pos(this, "[[<>m<>,[[<>61", 1), MCon.colorFrame());
        MText preTitle = new MText(MPos.pos(header, "[[<30>p,]]p<5>")).title("prePlace");
        preTitle.setForeground(MCon.colorTitleText());
        preTitle.setFont(MCon.fontTitle());
        MText tProject = ViewUtil.titleSelectable(MPos.pos("H[]<>p,]]p<5>", preTitle), pName, () -> ViewManager.displayDetail(pProject));
        MText tTitle = new MText(MPos.pos("H[]<>p,]]p<5>", tProject)).text(' ' + MLangManager.get("te.by"));
        tTitle.setForeground(MCon.colorTitleText());
        tTitle.setFont(MCon.fontTitle());
        ViewUtil.titleSelectable(MPos.pos("H[]<>p,]]p<5>", tTitle), pCreator.getName(), () -> ViewManager.displayDetail(pCreator));
        MButton bTut = ViewUtil.tutorialButton(header, "plcStr", EUTMView.VIEW_PLACE_STRUCTURE);
        new MPanel(MPos.pos("H][m,]]<>1<>", bTut), MCon.colorTitleLine());
    }

    @NotNull
    private MPanel panelLocal() {
        MFlowPanel header = new MFlowPanel((MMPos)LPos.pos(this, "[[<>m<>,[[<>61", 1), MCon.colorFrame());
        MLocal local = (MLocal)this.mSchematic;
        new MTitle(MPos.pos(header, "[[m,]]<>p<>")).rep("plcLoc", local.getFileName());
        MPanel panel = new MPanel(MPos.pos(this, "[[<30>m<30>,[[<76>238<>"), MCon.colorFrame());
        int w = Util.getWidth(MCon.fontText(), MLangManager.prefix("te.", "loc", "plce", "cre", "blks", "wid", "hig", "len", "difBlks")) + MCon.defaultGap();
        String posLeft = "[[<>" + w + ",[]<8>p";
        MText tStr = new MText(MPos.pos(panel, "[[<>" + w + ",[[p")).title("loc");
        MText tAdd = new MText(MPos.pos(posLeft, tStr)).title("added");
        MText tPlc = new MText(MPos.pos(posLeft, tAdd)).title("plce");
        MText tWid = new MText(MPos.pos(posLeft, tPlc)).title("wid");
        MText tHig = new MText(MPos.pos(posLeft, tWid)).title("hig");
        MText tLen = new MText(MPos.pos(posLeft, tHig)).title("len");
        MText tBlk = new MText(MPos.pos(posLeft, tLen)).title("blks");
        ViewUtil.addInfo(tStr, local.getFileName());
        ViewUtil.addInfo(tAdd, SharedUtil.formatDate(local.getDateAdded()));
        ViewUtil.addInfo(tPlc, local.getPlaced() == 1 ? MLangManager.get("te.time") : MLangManager.rep("te.times", local.getPlaced()));
        IDim dim = local.getDim();
        ViewUtil.addInfo(tWid, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getX())));
        ViewUtil.addInfo(tHig, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getY())));
        ViewUtil.addInfo(tLen, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getZ())));
        ViewUtil.addInfo(tBlk, CommonUtil.decMark(local.getBlocks()));
        return panel;
    }

    private int viewNoStr(boolean pPlaceStr) {
        MPanel panel = new MPanel(MPos.pos(this, pPlaceStr ? "||m,||250" : "||m,||203"), MCon.colorFrame());
        MPos pos = MPos.pos(panel, "||p,[[p");
        int widPlaced = 0;
        if (pPlaceStr) {
            MText tPlaced = new MText(pos).title("plcdStr");
            widPlaced = tPlaced.getPrefWidth();
            pos = MPos.pos("[[<>p,[]<25>p", tPlaced);
        }
        MText text = new MText(pos).title("noStr");
        int wid = Util.getWidth(MCon.fontButton(), MLangManager.prefix("bu.", "libStr", "libCol", "libLoc")) + 50;
        MButton bLibStr = new MButton(MPos.pos("[[<>" + wid + ",[]s", text)).title("libStr", new MTip());
        bLibStr.addAction(pEvent -> ViewManager.displayLeftMenu(ViewManager.VIEW_PROJECTS));
        MButton bLibCol = new MButton(MPos.pos("[[<>" + wid + ",[]s", bLibStr)).title("libCol", new MTip(2));
        bLibCol.addAction(pEvent -> ViewManager.displayLeftMenu(ViewManager.VIEW_COLLECTIONS));
        MButton bLibLoc = new MButton(MPos.pos("[[<>" + wid + ",[]s", bLibCol)).title("libLoc", new MTip(2));
        bLibLoc.addAction(pEvent -> ViewManager.displayLeftMenu(ViewManager.VIEW_LOCAL_STRUCTURES));
        bLibLoc.setEnabled(false);
        return CommonUtil.getMax(text.getPrefWidth(), bLibStr.getPrefWidth(), bLibCol.getPrefWidth(), bLibLoc.getPrefWidth(), widPlaced) + 30;
    }

    private int viewLoggedOut() {
        MText text = new MText(MPos.pos(this, "||p,||p")).title("loggedOut");
        return text.getPrefWidth() + 10;
    }

    @Override
    public void setPos(@NotNull IPos pPos, int pDir) {
        this.mPos = pPos;
        this.mRot = pDir;
        if (this.mComboRot != null) {
            this.mComboRot.setSelectedIndex(this.mRot);
            this.mFieldPosX.text(Integer.toString(this.mPos.getX()));
            this.mFieldPosY.text(Integer.toString(this.mPos.getY()));
            this.mFieldPosZ.text(Integer.toString(this.mPos.getZ()));
        }
    }

    public void setPlaceable(@Nullable IReadableStructure pSchematic) {
        this.mSchematic = pSchematic;
    }

    @NotNull
    private int[] getConvertPosDim() {
        if (this.mSchematic == null) {
            return new int[]{0, 0, 0, 0, 0};
        }
        return StrUtil.convertPosDim(this.mComboRot.getSelectedIndex(), this.mThirdX, this.mThirdY, this.mThirdZ, new Pos(this.mFieldPosX.getInt(), this.mFieldPosY.getInt(), this.mFieldPosZ.getInt()), this.mSchematic.getDim());
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(() -> {
            this.mAfterDisplay.run();
            this.afterDisplay();
        });
    }

    @Override
    @NotNull
    public String getURI() {
        String uri = !ISMContainer.getUpdateManager().isLegal() ? EURI.ATTR_ILLEGAL.toString() : (this.mSchematic == null ? (this.mMode == 1 ? "structure-placed/" : "no-structure/") : (ViewUtil.isLogoutShown() ? EURI.ATTR_LOGGED_OUT.toString() : (this.mSchematic instanceof IStorageStructure ? ((IStorageStructure)this.mSchematic).getProject().getURL() : "local-str/" + ((MLocal)this.mSchematic).getFileName() + '/')));
        return (Object)((Object)EURI.PRE_WORLD) + "place-structure/" + uri;
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_PLACE_STRUCTURE;
    }

    @Override
    public void deinitializeObjects() {
        this.mSchematic = null;
    }

    @Override
    public int getMenuButton() {
        return 6;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.PLACE_STRUCTURES;
    }
}

