/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.placed.EPlacedSortingType;
import de.maggicraft.ism.placed.IPlaced;
import de.maggicraft.ism.results.ViewPlaced;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.info.IWorldInfo;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MViewPlaced
extends MISMView<Integer> {
    private MCombo mFilter;
    private MCombo mSort;
    private int mIndexFilter = 0;
    private int mIndexSort = 0;

    @Override
    protected void displayState(Integer pMode) {
        MPanel header = ViewUtil.header(this, MLangManager.get("te.plcStrs"));
        ViewPlaced viewPlaced = new ViewPlaced(MPos.pos(this, "||<>m<>,[[<105>p"), ViewManager.getScroll()){

            @Override
            public void actPrefDim(int pWidth, int pHeight) {
                MViewPlaced.this.setDim(Math.max(pWidth, 500), pHeight + 185);
            }

            @Override
            @NotNull
            public List<IPlaced> getPlaced() {
                if (MViewPlaced.this.mFilter.getSelectedIndex() == 0) {
                    return ISMContainer.getPlacedManager().allPlaced();
                }
                EPlacedSortingType sorting = MViewPlaced.this.mSort.getSelectedIndex() == 0 ? EPlacedSortingType.SORT_DATE : EPlacedSortingType.SORT_DISTANCE;
                IWorldInfo world = ISMContainer.getWorldInfoManager().getWorldInfo();
                return ISMContainer.getPlacedManager().getPlacedWorld(world).getPlaceds(sorting, false);
            }
        };
        viewPlaced.buttonsResType(MPos.pos(header, "]]p<30>,]]p<5>"));
        viewPlaced.buttonsPage(MPos.pos(this, "||p,]]p<25>"));
        MFlowPanel panelFilter = new MFlowPanel(LPos.pos(this, "[[<>m<>,[[<61>60", 1), 61, MCon.colorFrame());
        MPanel view = new MPanel(MPos.pos(panelFilter, "||<30>M850<30>,||<>30<>"), MCon.colorFrame());
        int w = Util.getWidth(MLangManager.get("te.filter")) + MCon.defaultGap();
        this.mFilter = new MCombo(MPos.pos(view, "[[<" + w + ">p,||<>s<>")).title("filterAll", "curWrld");
        new MText(MPos.pos("V[[<>p,||<>p<>", this.mFilter)).title("filter");
        MText tSort = new MText(MPos.pos("H[]<30>p,||<>p<>", this.mFilter)).title("sort");
        this.mSort = new MCombo(MPos.pos("H[]p,||<>s<>", tSort)).title("dtPlc", "disStr");
        ViewUtil.initFilter(this, 121, MPos.pos("[]m<>,||<>30<>", this.mSort), viewPlaced);
        int index = ISMContainer.getWorldInfoManager().isLoggedIn() ? 1 : 0;
        this.mFilter.setEnabledInterval(0, index);
        this.mSort.setEnabledInterval(0, index);
        this.mFilter.setSelectedIndex(this.mIndexFilter);
        this.mFilter.addItemListener(pEvent -> {
            this.mIndexFilter = this.mFilter.getSelectedIndex();
            if (this.mIndexFilter == 0) {
                this.mSort.setSelectedIndex(0);
            }
            this.display(-1);
        });
        this.mSort.setSelectedIndex(this.mIndexSort);
        this.mSort.addItemListener(pEvent -> {
            this.mIndexSort = this.mSort.getSelectedIndex();
            if (this.mIndexSort == 1) {
                this.mFilter.setSelectedIndex(1);
            }
            this.display(-1);
        });
        viewPlaced.displayResPage();
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return EURI.PRE_LIBRARY.toString() + (Object)((Object)EURI.LIST) + "placed/";
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_PLACED;
    }

    @Override
    public int getMenuButton() {
        return 10;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.RECENTLY_PLACED;
    }
}

