/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.placed.IPlacedIntern;
import de.maggicraft.ism.str.BoundingBoxButton;
import de.maggicraft.ism.views.EChangeType;
import de.maggicraft.ism.views.MChangeView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.view.MPanel;
import org.jetbrains.annotations.NotNull;

public class MViewRemoveStructure
extends MChangeView {
    public MViewRemoveStructure() {
        super(EChangeType.TYPE_REMOVE);
    }

    @Override
    protected void displayState(Integer pMode) {
        if (!ISMContainer.getUpdateManager().isLegal()) {
            return;
        }
        if (ISMContainer.getWorldInfoManager().isLoggedOut()) {
            ViewUtil.titleTutorial(this, "remStr", EUTMView.VIEW_REMOVE_STRUCTURE);
            new MText(MPos.pos(this, "||p,||p")).title("loadRem");
        } else if (this.mPlaced == null) {
            this.viewListStrs();
        } else {
            this.viewRemove();
        }
    }

    private void viewRemove() {
        if (this.mPlaced == null) {
            throw new NullPointerException("placed structure must not be null");
        }
        MText tLast = this.mPlaced instanceof IPlacedIntern ? this.headerIntern((IPlacedIntern)this.mPlaced) : this.headerLocal(this.mPlaced);
        MPanel line = new MPanel(MPos.pos("V[[m,[]<25>1", tLast), MCon.colorTitleLine());
        BoundingBoxButton bbButton = new BoundingBoxButton(MPos.pos("V[[<30>p,[]s", line), this.mPlaced.getDim().getY());
        IPos pos = this.mPlaced.getCorner();
        bbButton.setNext(new int[]{pos.getX(), pos.getY(), pos.getZ(), this.mPlaced.getDimX(), this.mPlaced.getDimZ()});
        new MText(MPos.pos("[]p,[[<5>p", bbButton)).title("markAreaRem");
        MText last = new MText(MPos.pos("V[[<30>p,[]p<85>", bbButton)).title("noUndo");
        new MButton(MPos.pos(this, "[[<30>p,]]s<30>")).addAction(pEvent -> {
            ISMContainer.getBoundingBox().remove();
            this.mPlaced = null;
            ViewManager.displayLeftMenu(this, 0);
        }).title("cancel");
        new MButton(MPos.pos(this, "]]p<30>,]]s<30>")).addAction(pEvent -> {
            this.mPlaced.remove();
            this.mPlaced = null;
        }).title("remStr");
        this.setDim(last, 560);
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_REMOVE_STRUCTURE;
    }

    @Override
    public int getMenuButton() {
        return 8;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.REMOVE_STRUCTURES;
    }
}

