/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.placed.EPlacedType;
import de.maggicraft.ism.placed.IPlacedIntern;
import de.maggicraft.ism.placed.IPlacedWorld;
import de.maggicraft.ism.placed.PlacedIntern;
import de.maggicraft.ism.str.BoundingBoxButton;
import de.maggicraft.ism.str.StrUtil;
import de.maggicraft.ism.views.EChangeType;
import de.maggicraft.ism.views.MChangeView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.util.FilterInput;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.ism.world.util.Pos;
import de.maggicraft.mcommons.filter.types.MFilters;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MPictureMode;
import de.maggicraft.mgui.comp.MSwitcher;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.filter.check.MChecker;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.settings.MSettingGui;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class MViewReposStructure
extends MChangeView {
    private static final int FREE = 0;
    private static final int RELATIVE = 1;
    private static final int EXACT = 2;
    private MButton mRepos;
    private MCombo mRotate;
    private MField mRelativeX;
    private MField mRelativeY;
    private MField mRelativeZ;
    private MSwitcher mMirrorX;
    private MSwitcher mMirrorY;
    private MSwitcher mMirrorZ;
    private int mTaken;
    private int mThirdX;
    private int mThirdZ;
    private boolean mIsBBEnabled;

    public MViewReposStructure() {
        super(EChangeType.TYPE_REPOS);
    }

    @Override
    public void displayState(Integer pMode) {
        if (!ISMContainer.getUpdateManager().isLegal()) {
            return;
        }
        if (ISMContainer.getWorldInfoManager().isLoggedOut()) {
            ViewUtil.titleTutorial(this, "repStr", EUTMView.VIEW_REPOS_STRUCTURE);
            new MText(MPos.pos(this, "||p,||p")).title("loadRepos");
        } else if (this.mPlaced == null) {
            this.viewListStrs();
        } else {
            this.viewReposition();
        }
    }

    private void viewReposition() {
        this.mThirdX = 1;
        this.mThirdZ = 1;
        this.mIsBBEnabled = false;
        if (this.mPlaced == null) {
            throw new NullPointerException("placed structure must not be null");
        }
        MText tLast = this.mPlaced instanceof IPlacedIntern ? this.headerIntern((IPlacedIntern)this.mPlaced) : this.headerLocal(this.mPlaced);
        MFlowPanel headerRepos = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)tLast, 2), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerRepos, "[[m,]]<>p<>")).title("repos");
        int gapLeft = Util.getWidth(MCon.fontText(), MLangManager.prefix("te.pos", "X", "Y", "Z")) + MCon.defaultGap() + 30;
        int w = Util.getWidth(MLangManager.prefix("te.", "curPos", "relPos", "exactPos")) + MCon.defaultGap() * 2;
        IPos corner = this.mPlaced.getCorner();
        MPos pos = MPos.pos("V[[<" + gapLeft + '>' + w + ",[]<114>s", tLast);
        MField fCX = new MField(pos).text(CommonUtil.decMark(corner.getX()));
        MField fCY = new MField(MPos.pos("[[<>" + w + ",[]s", fCX)).text(CommonUtil.decMark(corner.getY()));
        MField fCZ = new MField(MPos.pos("[[<>" + w + ",[]s", fCY)).text(CommonUtil.decMark(corner.getZ()));
        Color colorDisabled = MCon.colorFieldTextPlaceholder().brighter();
        fCX.setDisabledTextColor(colorDisabled);
        fCY.setDisabledTextColor(colorDisabled);
        fCZ.setDisabledTextColor(colorDisabled);
        fCX.setEnabled(false);
        fCY.setEnabled(false);
        fCZ.setEnabled(false);
        new MText(MPos.pos("||p,][p<10>", fCX)).title("curPos");
        this.mRelativeX = new MField(MPos.pos("[]" + w + ",[]<114>s", fCX, tLast));
        this.mRelativeY = new MField(MPos.pos("[[<>" + w + ",[]s", this.mRelativeX));
        this.mRelativeZ = new MField(MPos.pos("[[<>" + w + ",[]s", this.mRelativeY));
        new MText(MPos.pos("||p,][p<10>", this.mRelativeX)).title("relPos");
        MField fEX = new MField(MPos.pos("[]" + w + ",[]<114>s", this.mRelativeX, tLast));
        MField fEY = new MField(MPos.pos("[[<>" + w + ",[]s", fEX));
        MField fEZ = new MField(MPos.pos("[[<>" + w + ",[]s", fEY));
        new MText(MPos.pos("||p,][p<10>", fEX)).title("exactPos");
        MText tX = new MText(MPos.pos("][p,||p", fCX)).title("posX");
        new MText(MPos.pos("][p,||p", fCY)).title("posY");
        new MText(MPos.pos("][p,||p", fCZ)).title("posZ");
        MChecker checker = new MChecker();
        checker.add(MFilters.filterInt(-this.mPlaced.getDim().getY() + 1, 255), true, fEY);
        checker.add(ViewUtil.WORLD_SIZE, true, fEX, fEZ);
        MFlowPanel headerRotate = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)fEZ, 3), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerRotate, "[[m,]]<>p<>")).title("rot");
        int pW = gapLeft - 30 + 3 * (w + MCon.defaultGap()) - MCon.defaultGap();
        MPanel panelRot = new MPanel(MPos.pos("[[<>" + pW + ",[]<85>110<>", tX, fEZ), MCon.colorFrame());
        this.mRotate = new MCombo(MPos.pos(panelRot, "]]p<>,[[<>30")).text("0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0");
        new MText(MPos.pos("V[[<>p,||<>p", this.mRotate)).title("rotStr");
        ImageIcon iconXZ = ImgUtil.getAppIcon("sp_xz_" + this.mThirdX + '_' + this.mThirdZ);
        final MButton buttonXZ = new MButton((MMPos)MPos.pos("]]65<>,[]65<>", this.mRotate), (Icon)iconXZ);
        new MPicture(MPicPos.pos("][p,||p<>", buttonXZ), ImgUtil.getAppIcon("xz_axes_" + this.mRotate.getSelectedIndex()), MPictureMode.CUT);
        MText tePlayerPos = new MText(MPos.pos("V[[<>p,[[<>p", buttonXZ)).text("rotation point");
        new MPicture(MPicPos.pos("[]<5>p,||<5>p<>", tePlayerPos), ImgUtil.getAppIcon("player"), MPictureMode.CUT);
        MFlowPanel headerMirror = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)panelRot, 4), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerMirror, "[[m,]]<>p<>")).title("mirr");
        MPanel panelMirror = new MPanel(MPos.pos("[[<>" + pW + ",[]<85>110<>", tX, panelRot), MCon.colorFrame());
        this.mMirrorX = new MSwitcher(MPos.pos(panelMirror, "]]p<>,[[<>30"), false).addAction(pEvent -> this.enableButton());
        this.mMirrorY = new MSwitcher(MPos.pos("V]]p<>,[]<10>30", this.mMirrorX), false).addAction(pEvent -> this.enableButton());
        this.mMirrorZ = new MSwitcher(MPos.pos("V]]p<>,[]<10>30<>", this.mMirrorY), false).addAction(pEvent -> this.enableButton());
        new MText(MPos.pos("V[[<>p,||<>p", this.mMirrorX)).rep("mir", "x");
        new MText(MPos.pos("V[[<>p,||p", this.mMirrorY)).rep("mir", "y");
        new MText(MPos.pos("V[[<>p,||p<>", this.mMirrorZ)).rep("mir", "z");
        MFlowPanel headerOther = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)panelMirror, 5), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerOther, "[[m,]]<>p<>")).title("other");
        MSwitcher swFlatten = MSettingGui.switcherBool(CSettings.SETTING_FLATTEN_REPOS, MPos.pos("[[<>p,[]<85>s", panelMirror));
        final BoundingBoxButton bbButton = new BoundingBoxButton(MPos.pos("[[<>p,[]s<85>", swFlatten), this.mPlaced.getDim().getY());
        new MText(MPos.pos("[]p,[[<5>p", bbButton)).title("markArea");
        new MButton(MPos.pos(this, "[[<30>p,]]s<25>")).addAction(pEvent -> {
            ISMContainer.getBoundingBox().remove();
            this.mPlaced = null;
            this.display(0);
        }).title("cancel");
        this.mRepos = new MButton(MPos.pos(this, "]]p<30>,]]s<25>")).addAction(pEvent -> this.repos(checker, fEX.getX(), fEY.getY(), fEZ.getInt(), swFlatten.isSelected())).title("uptStr");
        this.mRotate.addItemListener(pEvent -> {
            bbButton.setNext(this.getConvertPosDim());
            this.enableButton();
        });
        Runnable runnable = () -> bbButton.setNext(this.getConvertPosDim());
        this.initFields(this.mRelativeX, fEX, corner.getX(), checker, runnable);
        this.initFields(this.mRelativeY, fEY, corner.getY(), checker, runnable);
        this.initFields(this.mRelativeZ, fEZ, corner.getZ(), checker, runnable);
        buttonXZ.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                MViewReposStructure.this.mThirdX = 2 - ViewUtil.getThird(e.getY());
                MViewReposStructure.this.mThirdZ = ViewUtil.getThird(e.getX());
                buttonXZ.setIcon(ImgUtil.getAppIcon("sp_xz_" + MViewReposStructure.this.mThirdX + '_' + MViewReposStructure.this.mThirdZ));
                bbButton.setNext(MViewReposStructure.this.getConvertPosDim());
            }
        });
        this.enableButton();
        this.update();
        this.setDim(bbButton, 560);
        this.mIsBBEnabled = true;
        bbButton.setNext(this.getConvertPosDim());
    }

    private void repos(@NotNull MChecker pChecker, int pCornerX, int pCornerY, int pCornerZ, boolean pFlatten) {
        if (this.mPlaced == null) {
            throw new NullPointerException("placed structure must not be null");
        }
        if (!pChecker.check()) {
            return;
        }
        boolean containBedrock = true;
        if (pCornerY < 1) {
            int res = ViewUtil.noteBelow(this.getURI());
            if (res == 0) {
                return;
            }
            containBedrock = res == 2;
        } else if (pCornerY + this.mPlaced.getDim().getY() > 255 && !ViewUtil.noteAbove(this.getURI())) {
            return;
        }
        int[] dimPos = StrUtil.rotateRectangle(this.mRotate.getSelectedIndex(), this.mThirdX, this.mThirdZ, pCornerX, pCornerZ, this.mPlaced.getDimX(), this.mPlaced.getDimZ());
        int rot = (this.mPlaced.getRot() + this.mRotate.getSelectedIndex()) % 4;
        FilterInput input = new FilterInput(pCornerY, rot, containBedrock, this.mMirrorX.isSelected(), this.mMirrorY.isSelected(), this.mMirrorZ.isSelected());
        pCornerY = StrUtil.ensureCornerY(pCornerY, containBedrock);
        StringBuilder dim = new StringBuilder();
        dim.append("rX: ").append(this.mRelativeX.getInt());
        dim.append(", rY: ").append(this.mRelativeY.getInt());
        dim.append(", rZ: ").append(this.mRelativeZ.getInt());
        dim.append(", rot: ").append(Math.abs(this.mPlaced.getRot() - this.mRotate.getSelectedIndex()));
        if (this.mMirrorX.isSelected()) {
            dim.append(", mirX");
        }
        if (this.mMirrorY.isSelected()) {
            dim.append(", mirY");
        }
        if (this.mMirrorZ.isSelected()) {
            dim.append(", mirZ");
        }
        Pos cornerPos = new Pos(dimPos[0], pCornerY, dimPos[1]);
        this.mPlaced.reposition(dim.toString(), input, cornerPos, rot, dimPos[2], dimPos[3], pFlatten);
        this.mPlaced.deleteBackUp();
        IPlacedWorld placedWorld = ISMContainer.getPlacedManager().getPlacedWorld(ISMContainer.getWorldInfoManager().getWorldInfo());
        PlacedIntern placed = new PlacedIntern(placedWorld, EPlacedType.REPOSED, null, cornerPos, rot, dimPos[2], dimPos[3]);
        placedWorld.addPlaced(placed);
    }

    private void initFields(@NotNull MField pRelative, @NotNull MField pExact, int pPos, @NotNull MChecker pChecker, Runnable pChange) {
        pExact.text("0").filter(MFilters.FILTER_INTEGER);
        pRelative.addListener(pEvent -> {
            if (this.mTaken == 0) {
                this.mTaken = 1;
                if (MFilters.FILTER_INTEGER.isValid(pRelative.getText())) {
                    int exact = pPos + pRelative.getInt();
                    pExact.setText(Integer.toString(exact));
                    pChange.run();
                    this.enableButton();
                }
                this.mTaken = 0;
            }
        });
        pExact.addListener(pEvent -> {
            if (this.mTaken == 0) {
                this.mTaken = 2;
                if (!pExact.getText().isEmpty()) {
                    pChecker.check();
                }
                if (MFilters.FILTER_INTEGER.isValid(pExact.getText())) {
                    int relative = pExact.getInt() - pPos;
                    pRelative.setText(Integer.toString(relative));
                    pChange.run();
                    this.enableButton();
                }
                this.mTaken = 0;
            }
        });
        pRelative.text("0").filter(MFilters.FILTER_INTEGER);
    }

    private void enableButton() {
        boolean enabled = this.mRotate.getSelectedIndex() != 0 || this.mMirrorX.isSelected() || this.mMirrorY.isSelected() || this.mMirrorZ.isSelected() || MFilters.FILTER_INTEGER.isValid(this.mRelativeX.getText()) && this.mRelativeX.getInt() != 0 || MFilters.FILTER_INTEGER.isValid(this.mRelativeY.getText()) && this.mRelativeY.getInt() != 0 || MFilters.FILTER_INTEGER.isValid(this.mRelativeZ.getText()) && this.mRelativeZ.getInt() != 0;
        this.mRepos.setEnabled(enabled);
    }

    private int[] getConvertPosDim() {
        if (!this.mIsBBEnabled) {
            return new int[]{0, 0, 0, 0, 0};
        }
        IPos corner = this.mPlaced.getCorner();
        int[] rotated = StrUtil.rotateRectangle(this.mRotate.getSelectedIndex(), this.mThirdX, this.mThirdZ, corner.getX() + this.mRelativeX.getInt(), corner.getZ() + this.mRelativeZ.getInt(), this.mPlaced.getDimX(), this.mPlaced.getDimZ());
        return new int[]{rotated[0], corner.getY() + this.mRelativeY.getInt(), rotated[1], rotated[2], rotated[3]};
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_REPOS_STRUCTURE;
    }

    @Override
    public int getMenuButton() {
        return 7;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.REPOSITION_STRUCTURES;
    }
}

