/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.MTrackableDialog;
import de.maggicraft.ism.gui.MTrackableDialogs;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.scan_creators.IScanCreator;
import de.maggicraft.ism.scan_creators.ScanCreator;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.area.IAreaWrapper;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.ism.world.util.Offset;
import de.maggicraft.ism.world.util.Pos;
import de.maggicraft.ism.world.util.StrMetadata;
import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mcommons.filter.types.MFilters;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.filter.check.ICheckable;
import de.maggicraft.mgui.filter.check.MCheckField;
import de.maggicraft.mgui.filter.check.MCheckSign;
import de.maggicraft.mgui.filter.check.MChecker;
import de.maggicraft.mgui.listener.IAction;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mgui.view.util.EWindowSize;
import java.awt.Frame;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MViewScanStructure
extends MISMView<Integer> {
    public static final int MODE_SCANNED = 1;
    private static final String[] GENRES_STR = MLangManager.get("choGenre", "gModHou", "gModStrs", "gMed", "gCast", "gAsi", "gOri", "gShip", "gVehi", "gSci-", "r3D", "gPixe");
    private static final int MODE_NORMAL = 0;
    private Runnable mAfterDisplay;
    private MCombo mCreators;
    private MCombo mCreatorsEdit;
    private MField mRedX;
    private MField mRedY;
    private MField mRedZ;
    private MField mGreenX;
    private MField mGreenY;
    private MField mGreenZ;
    private MField mURL;
    private MField mFileName;
    private MField mStrName;
    private MField mTags;
    private MField mDesc;
    private MCombo mGenre;
    private MField mOffsetX;
    private MField mOffsetY;
    private MField mOffsetZ;
    private MText mDim;
    private MButton mUpdtArea;
    @NotNull
    private MChecker mChecker = new MChecker();
    private int mMode;
    private boolean mScan;

    @NotNull
    private static String posToString(@NotNull IPos pPos) {
        return MLangManager.rep("pos", pPos.getX(), pPos.getY(), pPos.getZ());
    }

    @NotNull
    private static String posToString(@NotNull MField pFieldX, @NotNull MField pFieldY, @NotNull MField pFieldZ) {
        return MLangManager.rep("pos", pFieldX.getInt(), pFieldY.getInt(), pFieldZ.getInt());
    }

    private static String valid(@NotNull MField pField) {
        String str = pField.getText();
        if (str.equals(pField.getPlaceholder())) {
            str = "";
        }
        return str;
    }

    private static void addCreator() {
        new MTrackableDialog((Frame)ISMContainer.getStrExplorer().getFrame(), EWindowSize.THREE){

            @Override
            public void init(@NotNull MDialog pView) {
                MChecker checkerCreator = new MChecker();
                MField fName = new MField(MPos.pos(this, "]]175,[[s")).title("creName");
                MCheckField checkable = new MCheckField(fName, MFilters.FILTER_URL, MPos.pos("][30,||<>s<>", fName));
                checkable.getCheckSign().getButton().tip(new MTip(MFilters.FILTER_URL.desc()));
                checkable.getCheckSign().getButton().setEnabled(false);
                checkerCreator.add(checkable);
                MField fURL = new MField(MPos.pos("V]]175,[]s", fName)).filter(MFilters.FILTER_URL).title("link");
                new MText(MPos.pos("V[[p,||<>p", fName)).title("_nme");
                new MText(MPos.pos("V[[p,||p", fURL)).title("url");
                int wid = Util.getWidth(MCon.fontButton(), MLangManager.get("bu.cnl", "bu.add")) + 50;
                new MButton(MPos.pos(pView, "[[" + wid + ",]]s")).addAction(pEvent -> pView.dispose()).title("cnl");
                new MButton(MPos.pos(pView, "]]" + wid + ",]]s")).addAction(pEvent -> {
                    if (!checkerCreator.check()) {
                        return;
                    }
                    String name = fName.getText();
                    String url = fURL.getPlaceholder().equals(fURL.getText()) ? "" : fURL.getText();
                    ISMContainer.getScanCreatorsManager().addCreator(new ScanCreator(name, url));
                    pView.dispose();
                }).title("add");
            }

            @Override
            public void afterInit() {
                SwingUtilities.invokeLater(this::afterDisplay);
            }

            @Override
            @NotNull
            public String getURI() {
                return (Object)((Object)EURI.PRE_WORLD) + "scan-structure/" + (Object)((Object)EURI.DIALOG) + "add-creator/";
            }
        }.visible().title("addCre");
    }

    @Override
    public void displayState(Integer pMode) {
        if (!ISMContainer.getUpdateManager().isLegal()) {
            return;
        }
        ViewUtil.titleTutorial(this, "scnStr", EUTMView.VIEW_SCAN_STRUCTURE);
        this.mMode = pMode;
        if (pMode == 1) {
            ISMContainer.getScanCreatorsManager().clearActions();
            MText text = new MText(MPos.pos(this, "||p,||p")).title("scanned");
            new MButton(MPos.pos("[[<>p,[]s", text)).addAction(pEvent -> ViewManager.displayLeftMenu(this, 0)).title("scanNew");
            this.mAfterDisplay = () -> this.setDim(400, 130);
        } else if (ISMContainer.getWorldInfoManager().isLoggedOut()) {
            ISMContainer.getScanCreatorsManager().clearActions();
            new MText(MPos.pos(this, "||p,||p")).title("loadScan");
            this.mAfterDisplay = () -> this.setDim(400, 130);
        } else {
            this.viewScan();
        }
    }

    private void viewScan() {
        ISMContainer.getScanCreatorsManager().clearActions();
        this.mChecker = new MChecker();
        MFlowPanel headerPos = new MFlowPanel(LPos.pos(this, "[[<>m<>,[[<76>45", 2), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerPos, "[[m,]]<>p<>")).title("area");
        MPanel pPos = this.panelArea();
        MFlowPanel headerInfo = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)pPos, 3), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerInfo, "[[m,]]<>p<>")).title("info");
        MPanel pInfo = this.panelInfo(pPos);
        MFlowPanel headerSettings = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)pInfo, 4), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerSettings, "[[m,]]<>p<>")).title("strSet");
        MPanel panel = this.panelSettings(pInfo);
        this.mAfterDisplay = () -> this.setDim(panel, 650);
        ISMContainer.getScanCreatorsManager().addAction(() -> this.mCreators.text(ISMContainer.getScanCreatorsManager().comboNames()));
        IAreaWrapper area = ISMContainer.getArea();
        new MButton(MPos.pos(this, "[[<30>p,]]s<30>")).addAction(pEvent -> area.cancel()).title("cancel");
        new MButton(MPos.pos(this, "]]p<30>,]]s<30>")).addAction(pEvent -> {
            if (this.checkScan(this.mChecker)) {
                this.scanStructure(area);
            }
        }).title("scanStr");
    }

    private void scanStructure(@NotNull IAreaWrapper pArea) {
        File file = ISMContainer.getLocalManager().fileLocal(this.mFileName.getText());
        try {
            String creator = (String)this.mCreators.getSelectedItem();
            if (creator == null) {
                creator = "unknown creator";
            }
            int genreID = this.mGenre.getSelectedIndex() - 1;
            StrMetadata metadata = new StrMetadata(this.mStrName.getText(), creator, MViewScanStructure.valid(this.mDesc), MViewScanStructure.valid(this.mTags), MViewScanStructure.valid(this.mURL), genreID);
            Offset offset = new Offset(this.mOffsetX.getInt(), this.mOffsetY.getInt(), this.mOffsetZ.getInt());
            ISMContainer.getScanStructure().createStrFile(metadata, ISMContainer.getArea().getDim(), offset, file);
            ISMContainer.getLocalManager().addLocal(file);
            ISMContainer.getLocalManager().store();
        }
        catch (Exception pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @NotNull
    private MPanel panelArea() {
        MPanel pPos = new MPanel(MPos.pos(this, "[[<30>M500<30>,[[<136>246"), MCon.colorFrame());
        MText tRed = new MText(MPos.pos(pPos, "[[<>p,[[<>p")).title("red");
        this.mRedZ = new MField(MPos.pos("V]]75<>,[]<10>s", tRed)).text("z").filter(ViewUtil.WORLD_SIZE);
        this.mRedY = new MField(MPos.pos("][75,[]<10>s", this.mRedZ, tRed)).text("y").filter(ViewUtil.WORLD_HEIGHT);
        this.mRedX = new MField(MPos.pos("][75,[]<10>s", this.mRedY, tRed)).text("x").filter(ViewUtil.WORLD_SIZE);
        new MText(MPos.pos("V[[<>p,||p", this.mRedX)).title("pos");
        MText tGreen = new MText(MPos.pos("V[[<>p,[]<30>p", this.mRedZ)).title("green");
        this.mGreenZ = new MField(MPos.pos("V]]75<>,[]<10>s<>", tGreen)).text("z").filter(ViewUtil.WORLD_SIZE);
        this.mGreenY = new MField(MPos.pos("][75,[]<10>s<>", this.mGreenZ, tGreen)).text("y").filter(ViewUtil.WORLD_HEIGHT);
        this.mGreenX = new MField(MPos.pos("][75,[]<10>s<>", this.mGreenY, tGreen)).text("x").filter(ViewUtil.WORLD_SIZE);
        new MText(MPos.pos("V[[<>p,||p<>", this.mGreenX)).title("pos");
        this.mUpdtArea = new MButton(MPos.pos("V]]p<>,[]s<>", this.mGreenZ)).addAction(pEvent -> {
            ISMContainer.getArea().updateArea(this.posGreen(), this.posRed());
            String uri = (Object)((Object)EURI.PRE_WORLD) + "scan-structure/" + (Object)((Object)EURI.DIALOG) + "info-update-area/";
            MTrackableDialogs.makeNote(MPos.getFrame(this), MLangManager.get("note.bbUpdt"), uri);
            this.updateDim();
        }).title("apply");
        new MText(MPos.pos("V[[<>p,||p<>", this.mUpdtArea)).title("updtBB");
        PosListener listener = new PosListener();
        listener.action(null);
        this.mChecker.add(listener);
        MText tDim = new MText(MPos.pos("V[[<>p,[]p<>", this.mUpdtArea)).title("dimScan");
        this.mDim = new MText(MPos.pos("V]]p<>,]]p<>", tDim));
        this.setPosRedImpl(ISMContainer.getArea().getPosRed());
        this.setPosGreenImpl(ISMContainer.getArea().getPosGreen());
        return pPos;
    }

    @NotNull
    private MPanel panelInfo(@NotNull IComp pTop) {
        MPanel panel = new MPanel(MPos.pos("V[[<30>M500<30>,[]<85>334", pTop), MCon.colorFrame());
        MText minReq = new MText(MPos.pos(panel, "[[<>p,[[<>p")).title("minRequ");
        this.mFileName = new MField(MPos.pos("V]]175<>,[]s", minReq)).title("fnme");
        this.mChecker.add(MFilters.FILTER_FILENAME, this.mFileName);
        this.mStrName = new MField(MPos.pos("V]]175<>,[]s", this.mFileName)).title("snme");
        this.mChecker.add(MFilters.FILTER_URL, this.mStrName);
        this.mCreators = new MCombo(MPos.pos("V]]175<>,[]s", this.mStrName)).text(ISMContainer.getScanCreatorsManager().comboNames());
        this.mCreators.addItemListener(pEvent -> {
            if (this.mCreators.getSelectedIndex() == 0) {
                this.mURL.setText(this.mURL.getPlaceholder());
            } else if (this.mURL.getText().equals(this.mURL.getPlaceholder())) {
                this.mURL.setText(ISMContainer.getScanCreatorsManager().get(this.mCreators.getSelectedIndex() - 1).getURL());
            }
        });
        this.mChecker.add(0, this.mCreators, MLangManager.get("checkCre"));
        new MButton(MPos.pos("][p,||30", this.mCreators)).addAction(pEvent -> this.editCreators()).title("edit");
        this.mGenre = new MCombo(MPos.pos("V]]175<>,[]s", this.mCreators)).text(GENRES_STR);
        this.mChecker.add(0, this.mGenre, MLangManager.get("checkGen"));
        this.mTags = new MField(MPos.pos("V]]175<>,[]s", this.mGenre)).title("tags").filter(new MFilter(){

            @Override
            @NotNull
            public String validate(@NotNull String pS) {
                return MFilter.validate(pS, LEGAL_URL_CHARS, true);
            }

            @Override
            public boolean isValid(@NotNull String pS) {
                return MFilter.isValid(pS, LEGAL_URL_CHARS, true);
            }

            @Override
            @NotNull
            public String desc() {
                return MLangManager.get("sepTags");
            }
        });
        this.mDesc = new MField(MPos.pos("V]]175<>,[]s<>", this.mTags)).text("desc").filter(MFilters.FILTER_URL);
        this.mURL = new MField(MPos.pos("V]]175<>,[]s<>", this.mDesc)).text("link").filter(MFilters.FILTER_URL);
        new MText(MPos.pos("V[[<>p,||<>p", this.mFileName)).title("fnme");
        new MText(MPos.pos("V[[<>p,||p", this.mStrName)).title("_nme");
        new MText(MPos.pos("V[[<>p,||p", this.mCreators)).title("_cre");
        new MText(MPos.pos("V[[<>p,||p", this.mGenre)).title("gen");
        new MText(MPos.pos("V[[<>p,||p", this.mTags)).title("tags");
        new MText(MPos.pos("V[[<>p,||p", this.mDesc)).title("_desc");
        new MText(MPos.pos("V[[<>p,||p<>", this.mURL)).title("_link");
        return panel;
    }

    @NotNull
    private MPanel panelSettings(@NotNull IComp pTop) {
        MPanel panel = new MPanel(MPos.pos("V[[<30>M500<30>,[]<85>120<85>", pTop), MCon.colorFrame());
        MFilter offsetFilter = MFilters.filterInt(-1000, 1000);
        this.mOffsetX = new MField(MPos.pos(panel, "]]75<>,[[<>s")).text("0").filter(offsetFilter);
        this.mOffsetY = new MField(MPos.pos("V]]75<>,[]s", this.mOffsetX)).text("0").filter(offsetFilter);
        this.mOffsetZ = new MField(MPos.pos("V]]75<>,[]s<>", this.mOffsetY)).text("0").filter(offsetFilter);
        new MText(MPos.pos("V[[<>p,||<>p", this.mOffsetX)).title("ofX");
        new MText(MPos.pos("V[[<>p,||p", this.mOffsetY)).title("ofY");
        new MText(MPos.pos("V[[<>p,||p<>", this.mOffsetZ)).title("ofZ");
        return panel;
    }

    private boolean checkScan(@NotNull MChecker pChecker) {
        if (!pChecker.check()) {
            return false;
        }
        IPos posRed = ISMContainer.getArea().getPosRed();
        IPos posGreen = ISMContainer.getArea().getPosGreen();
        if (posRed == null) {
            posRed = new Pos(this.mRedX.getInt(), this.mRedY.getInt(), this.mRedZ.getInt());
        }
        if (posGreen == null) {
            posGreen = new Pos(this.mGreenX.getInt(), this.mGreenY.getInt(), this.mGreenZ.getInt());
        }
        final boolean scanRed = posRed.getX() == this.mRedX.getInt() && posRed.getY() == this.mRedY.getInt() && posRed.getZ() == this.mRedZ.getInt();
        final boolean scanGreen = posGreen.getX() == this.mGreenX.getInt() && posGreen.getY() == this.mGreenY.getInt() && posGreen.getZ() == this.mGreenZ.getInt();
        boolean bl = this.mScan = scanRed && scanGreen;
        if (!this.mScan) {
            final IPos finalPosRed = posRed;
            final IPos finalPosGreen = posGreen;
            new MTrackableDialog(MPos.getFrame(this), EWindowSize.THREE){

                @Override
                public void init(@NotNull MDialog pDialog) {
                    String difCorners;
                    String difBoundingBox;
                    String difColors;
                    if (!scanRed && !scanGreen) {
                        difColors = MLangManager.get("redGreen");
                        difBoundingBox = '(' + MViewScanStructure.posToString(finalPosRed) + "; " + MViewScanStructure.posToString(finalPosGreen) + ')';
                        difCorners = '(' + MViewScanStructure.posToString(MViewScanStructure.this.mRedX, MViewScanStructure.this.mRedY, MViewScanStructure.this.mRedZ) + "; " + MViewScanStructure.posToString(MViewScanStructure.this.mGreenX, MViewScanStructure.this.mGreenY, MViewScanStructure.this.mGreenZ) + ')';
                    } else if (!scanRed) {
                        difColors = MLangManager.get("re");
                        difBoundingBox = '(' + MViewScanStructure.posToString(finalPosRed) + ')';
                        difCorners = '(' + MViewScanStructure.posToString(MViewScanStructure.this.mRedX, MViewScanStructure.this.mRedY, MViewScanStructure.this.mRedZ) + ')';
                    } else {
                        difColors = MLangManager.get("gre");
                        difBoundingBox = '(' + MViewScanStructure.posToString(finalPosGreen) + ')';
                        difCorners = '(' + MViewScanStructure.posToString(MViewScanStructure.this.mGreenX, MViewScanStructure.this.mGreenY, MViewScanStructure.this.mGreenZ) + ')';
                    }
                    new MText(MPos.pos(pDialog, "||m,||m<90>")).rep("te.difCorners", difColors, difBoundingBox, difCorners);
                    int wid = Util.getWidth(MCon.fontButton(), MLangManager.get("bu.bBox", "bu.corners", "bu.cnl")) + 50;
                    MButton button = new MButton(MPos.pos(pDialog, "]]" + wid + ",]]s")).addAction(pEvent -> {
                        MViewScanStructure.this.setPosRedImpl(ISMContainer.getArea().getPosRed());
                        MViewScanStructure.this.setPosGreenImpl(ISMContainer.getArea().getPosGreen());
                        this.dispose();
                        MViewScanStructure.this.mScan = true;
                    }).title("bBox");
                    new MButton(MPos.pos("V]]" + wid + ",][s", button)).addAction(pEvent -> {
                        ISMContainer.getArea().updateArea(MViewScanStructure.this.posGreen(), MViewScanStructure.this.posRed());
                        this.dispose();
                        MViewScanStructure.this.mScan = true;
                    }).title("corners");
                    new MButton(MPos.pos(pDialog, "[[" + wid + ",]]s")).addAction(pEvent -> this.dispose()).title("cnl");
                }

                @Override
                public void afterInit() {
                    SwingUtilities.invokeLater(this::afterDisplay);
                }

                @Override
                @NotNull
                protected String getURI() {
                    return (Object)((Object)EURI.PRE_WORLD) + "scan-structure/" + (Object)((Object)EURI.DIALOG) + "invalid-area/";
                }
            }.title("difPos").visible();
        }
        this.checkFileName();
        return this.mScan;
    }

    private boolean checkFileName() {
        final File fileStr = ISMContainer.getLocalManager().fileLocal(this.mFileName.getText());
        if (fileStr.exists()) {
            new MTrackableDialog(MPos.getFrame(this), EWindowSize.FOUR){

                @Override
                public void init(@NotNull MDialog pDialog) {
                    new MText(MPos.pos(pDialog, "||m,||m<105>")).rep("alrdyExists", fileStr.getAbsolutePath());
                    int wid = Util.getWidth(MCon.fontButton(), MLangManager.get("bu.rpl", "bu.cnl")) + 50;
                    MButton bRepl = new MButton(MPos.pos(pDialog, "]]" + wid + ",]]s")).addAction(pEvent -> {
                        this.dispose();
                        MViewScanStructure.this.mScan = true;
                    }).title("rpl");
                    MButton bChange = new MButton((MMPos)MPos.pos("V[[" + wid + ",][s", bRepl), null).title("change");
                    MChecker checkerFileName = new MChecker();
                    MField fFileName = new MField(MPos.pos("[]p<45>,||s", bChange)).title("fileNme");
                    fFileName.setText(MViewScanStructure.this.mFileName.getText());
                    checkerFileName.add(MFilters.FILTER_FILENAME, fFileName);
                    bChange.addActionListener(pEvent -> {
                        if (checkerFileName.check()) {
                            MViewScanStructure.this.mFileName.setText(fFileName.getText());
                        }
                        this.dispose();
                        MViewScanStructure.this.mScan = MViewScanStructure.this.checkFileName();
                    });
                    new MButton(MPos.pos(pDialog, "[[" + wid + ",]]s")).addAction(pEvent -> {
                        this.dispose();
                        MViewScanStructure.this.mScan = false;
                    }).title("cnl");
                }

                @Override
                public void afterInit() {
                    SwingUtilities.invokeLater(this::afterDisplay);
                }

                @Override
                @NotNull
                protected String getURI() {
                    return (Object)((Object)EURI.PRE_WORLD) + "scan-structure/" + (Object)((Object)EURI.DIALOG) + "invalid-filename/";
                }
            }.title("alrdyExists").setVisible(true);
        } else {
            this.mScan = true;
        }
        return this.mScan;
    }

    private void editCreators() {
        new MTrackableDialog(ISMContainer.getStrExplorer().getFrame(), EWindowSize.FOUR){

            @Override
            public void init(@NotNull MDialog pView) {
                int wid = Util.getWidth(MCon.fontButton(), MLangManager.get("bu.add", "bu.rmv", "bu.cnl", "bu.apply", "bu.ok")) + 50;
                MButton bAdd = new MButton(MPos.pos(pView, "]]p,[[s")).addAction(pEvent -> MViewScanStructure.addCreator()).title("add");
                MPanel line = new MPanel(MPos.pos("V||m,[]1", bAdd));
                MButton bRemove = new MButton(MPos.pos("]]p<>,[]s", line)).addAction(pEvent -> ISMContainer.getScanCreatorsManager().remove(MViewScanStructure.this.mCreatorsEdit.getSelectedIndex())).title("rmv");
                MChecker checkEditCreator = new MChecker();
                MField fName = new MField(MPos.pos("V]]175,[]s", bRemove)).filter(MFilters.FILTER_URL);
                MCheckField checkable = new MCheckField(fName, MFilters.FILTER_URL, MPos.pos("][30,||<>s<>", fName));
                checkable.getCheckSign().getButton().tip(new MTip(MFilters.FILTER_URL.desc()));
                checkable.getCheckSign().getButton().setEnabled(false);
                checkable.setPlaceholderValid(true);
                checkEditCreator.add(checkable);
                MField fURL = new MField(MPos.pos("V]]175,[]s", fName)).filter(MFilters.FILTER_URL);
                MViewScanStructure.this.mCreatorsEdit = new MCombo(MPos.pos("V[[175<>,[]s", line));
                MViewScanStructure.this.mCreatorsEdit.addItemListener(pEvent -> {
                    IScanCreator creator = ISMContainer.getScanCreatorsManager().get(MViewScanStructure.this.mCreatorsEdit.getSelectedIndex());
                    MViewScanStructure.this.mCreators.setSelectedIndex(MViewScanStructure.this.mCreatorsEdit.getSelectedIndex() + 1);
                    if (MViewScanStructure.this.mURL.getText().equals(MViewScanStructure.this.mURL.getPlaceholder())) {
                        MViewScanStructure.this.mURL.setText(creator.getURL());
                    }
                    fName.text(creator.getName());
                    fURL.text(creator.getURL());
                });
                new MText(MPos.pos("V[[p,||<>p", fName)).title("nme");
                new MText(MPos.pos("V[[p,||p", fURL)).title("url");
                Runnable action = () -> {
                    MViewScanStructure.this.mCreatorsEdit.text(ISMContainer.getScanCreatorsManager().getNames());
                    boolean enabled = ISMContainer.getScanCreatorsManager().size() > 0;
                    bRemove.setEnabled(enabled);
                    fName.setEnabled(enabled);
                    fURL.setEnabled(enabled);
                    if (enabled) {
                        IScanCreator creator = ISMContainer.getScanCreatorsManager().get(MViewScanStructure.this.mCreatorsEdit.getSelectedIndex());
                        MViewScanStructure.this.mCreators.setSelectedIndex(MViewScanStructure.this.mCreatorsEdit.getSelectedIndex() + 1);
                        fName.text(creator.getName());
                        fURL.text(creator.getURL());
                    } else {
                        fName.text("");
                        fURL.text("");
                    }
                };
                ISMContainer.getScanCreatorsManager().addAction(action);
                action.run();
                new MButton(MPos.pos(pView, "[[" + wid + ",]]s")).addAction(pEvent -> {
                    pView.dispose();
                    ISMContainer.getScanCreatorsManager().removeAction(action);
                }).title("cnl");
                MButton bOk = new MButton(MPos.pos(pView, "]]" + wid + ",]]s")).addAction(pEvent -> {
                    if (!checkEditCreator.check()) {
                        return;
                    }
                    ISMContainer.getScanCreatorsManager().editCreator(MViewScanStructure.this.mCreatorsEdit.getSelectedIndex(), fName.getText(), fURL.getText());
                    ISMContainer.getScanCreatorsManager().removeAction(action);
                    pView.dispose();
                }).title("ok");
                new MButton(MPos.pos("H][" + wid + ",]]s", bOk)).addAction(pEvent -> {
                    if (!checkEditCreator.check()) {
                        return;
                    }
                    ISMContainer.getScanCreatorsManager().editCreator(MViewScanStructure.this.mCreatorsEdit.getSelectedIndex(), fName.getText(), fURL.getText());
                }).title("apply");
            }

            @Override
            public void afterInit() {
                SwingUtilities.invokeLater(this::afterDisplay);
            }

            @Override
            @NotNull
            protected String getURI() {
                return (Object)((Object)EURI.PRE_WORLD) + "scan-structure/" + (Object)((Object)EURI.DIALOG) + "edit-creator/";
            }
        }.visible().title("edtCre");
    }

    public void setPosRed(@Nullable IPos pPos) {
        if (ISMContainer.getStrExplorer().isDisplayed()) {
            ViewManager.displayLeftMenu(ViewManager.VIEW_SCAN_STRUCTURE);
        }
        this.setPosRedImpl(pPos);
    }

    private void setPosRedImpl(@Nullable IPos pPos) {
        if (this.mRedX != null) {
            if (pPos == null) {
                this.mRedX.setText(this.mRedX.getPlaceholder());
                this.mRedY.setText(this.mRedY.getPlaceholder());
                this.mRedZ.setText(this.mRedZ.getPlaceholder());
            } else {
                this.mRedX.setText(Integer.toString(pPos.getX()));
                this.mRedY.setText(Integer.toString(pPos.getY()));
                this.mRedZ.setText(Integer.toString(pPos.getZ()));
            }
            this.updateDim();
        }
    }

    public void setPosGreen(@Nullable IPos pPos) {
        if (ISMContainer.getStrExplorer().isDisplayed()) {
            ViewManager.displayLeftMenu(ViewManager.VIEW_SCAN_STRUCTURE);
        }
        this.setPosGreenImpl(pPos);
    }

    private void setPosGreenImpl(@Nullable IPos pPos) {
        if (this.mGreenX != null) {
            if (pPos == null) {
                this.mGreenX.setText(this.mGreenX.getPlaceholder());
                this.mGreenY.setText(this.mGreenY.getPlaceholder());
                this.mGreenZ.setText(this.mGreenZ.getPlaceholder());
            } else {
                this.mGreenX.setText(Integer.toString(pPos.getX()));
                this.mGreenY.setText(Integer.toString(pPos.getY()));
                this.mGreenZ.setText(Integer.toString(pPos.getZ()));
            }
            this.updateDim();
        }
    }

    private void updateDim() {
        IDim dim = ISMContainer.getArea().getDim();
        this.mDim.rep("whl", CommonUtil.decMark(dim.getX()), CommonUtil.decMark(dim.getY()), CommonUtil.decMark(dim.getZ()));
    }

    @NotNull
    private IPos posGreen() {
        return new Pos(this.mGreenX.getInt(), this.mGreenY.getInt(), this.mGreenZ.getInt());
    }

    @NotNull
    private IPos posRed() {
        return new Pos(this.mRedX.getInt(), this.mRedY.getInt(), this.mRedZ.getInt());
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(() -> {
            this.mAfterDisplay.run();
            this.afterDisplay();
        });
    }

    @Override
    @NotNull
    public String getURI() {
        String uri = !ISMContainer.getUpdateManager().isLegal() ? EURI.ATTR_ILLEGAL.toString() : (this.mMode == 1 ? "scanned/" : (ISMContainer.getWorldInfoManager().isLoggedOut() ? EURI.ATTR_LOGGED_OUT.toString() : "scan/"));
        return (Object)((Object)EURI.PRE_WORLD) + "scan-structure/" + uri;
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_SCAN_STRUCTURE;
    }

    @Override
    public int getMenuButton() {
        return 5;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.SCAN_STRUCTURES;
    }

    private class PosListener
    implements IAction<DocumentEvent>,
    ICheckable {
        @NotNull
        private final MCheckSign mCheckSign;

        PosListener() {
            this.mCheckSign = new MCheckSign(MViewScanStructure.this.mUpdtArea, null).title("minArea");
            MViewScanStructure.this.mRedX.addListener((IAction)this);
            MViewScanStructure.this.mRedY.addListener((IAction)this);
            MViewScanStructure.this.mRedZ.addListener((IAction)this);
            MViewScanStructure.this.mGreenX.addListener((IAction)this);
            MViewScanStructure.this.mGreenY.addListener((IAction)this);
            MViewScanStructure.this.mGreenZ.addListener((IAction)this);
        }

        @Override
        public void showFeedback() {
            this.mCheckSign.show();
        }

        @Override
        @NotNull
        public PosListener title(String pTitle) {
            this.mCheckSign.title(pTitle);
            return this;
        }

        @Override
        @NotNull
        public PosListener text(String pText) {
            this.mCheckSign.text(pText);
            return this;
        }

        @Override
        @NotNull
        public MCheckSign getCheckSign() {
            return this.mCheckSign;
        }

        @Override
        public boolean isValid() {
            boolean validHeight = ViewUtil.WORLD_HEIGHT.isValid(MViewScanStructure.this.mRedY.getText()) && ViewUtil.WORLD_HEIGHT.isValid(MViewScanStructure.this.mGreenY.getText()) && !MViewScanStructure.this.mRedY.getText().equals(MViewScanStructure.this.mGreenY.getText());
            return this.isValid(MViewScanStructure.this.mRedX, MViewScanStructure.this.mGreenX) && validHeight && this.isValid(MViewScanStructure.this.mRedZ, MViewScanStructure.this.mGreenZ);
        }

        @Override
        public void action(DocumentEvent pEvent) {
            SwingUtilities.invokeLater(() -> MViewScanStructure.this.mUpdtArea.setEnabled(this.isValid()));
        }

        private boolean isValid(@NotNull MField pField1, @NotNull MField pField2) {
            return ViewUtil.WORLD_SIZE.isValid(pField1.getText()) && ViewUtil.WORLD_SIZE.isValid(pField2.getText()) && !pField1.getText().equals(pField2.getText());
        }
    }
}

