/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.ESearchMode;
import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.MMenuHorizontal;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.results.ViewRes;
import de.maggicraft.ism.search.IResSearch;
import de.maggicraft.ism.search.Search;
import de.maggicraft.ism.search.SearchManager;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MRadio;
import de.maggicraft.mgui.comp.MSlider;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.comp.MToggle;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.schemes.types.MSchemeFont;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import java.awt.FontMetrics;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class MViewSearchRes
extends MISMView<Integer> {
    private static final String[] MENU_TITLES = new String[]{"vAll", "vStrs", "vCol", "vCres"};
    private static final String[] URIS = new String[]{"all/", "structures/", "collections/", "creators/"};
    private ViewRes mSearchRes;
    private MField mFieldSearch;
    private MText mResStats;
    private MMenuHorizontal mMenu;
    private MFlowPanel mPanelSettings;
    private MPanel mSearchBar;
    private MEditor mNoResults;
    private int mMinDisplayWidth;
    private int mMode = 0;
    private boolean mSearchSettingsShown = false;

    @Override
    public void initialize() {
        MPanel panelBelow = this.initHeader();
        this.panelSettings();
        MButton bSearch = new MButton(MPos.pos(this.mSearchBar, "]]p<>,[[<>30")).addAction(pEvent -> ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, this.mFieldSearch.getText(), ESearchMode.SEARCH_ALL)).title("search");
        this.mFieldSearch = new MField(MPos.pos("][<>m,||<>30", bSearch)).title("search");
        this.mFieldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 10) {
                    ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, MViewSearchRes.this.mFieldSearch.getText(), ESearchMode.SEARCH_ALL);
                }
            }
        });
        this.initMenu(this.mSearchBar);
        this.mSearchRes = new ViewRes(MPos.pos(this, "||m,[[<130>p"), ViewManager.getScroll(), CSettings.SETTING_VIEW_RES, true){

            @Override
            public void actPrefDim(int pWidth, int pHeight) {
                MViewSearchRes.this.setDim(MViewSearchRes.this.mMinDisplayWidth, pHeight + 215);
            }

            @Override
            public int getSort() {
                return ViewManager.SEARCH_MANAGER.mSetSort.getValue();
            }

            @Override
            public void setBounds(int pX, int pY, int pWidth, int pHeight) {
                if (MViewSearchRes.this.mSearchSettingsShown) {
                    pWidth -= 300;
                }
                super.setBounds(pX, pY, pWidth, pHeight);
            }

            @Override
            protected void highlight(@NotNull List<IResSearch> pSearchRes) {
                if (ViewManager.SEARCH_MANAGER.getQuery() != null) {
                    for (IResSearch res : pSearchRes) {
                        res.mark(ViewManager.SEARCH_MANAGER.getQuery());
                    }
                }
            }

            @Override
            protected void showNoResults() {
                if (MViewSearchRes.this.mNoResults == null) {
                    MViewSearchRes.this.mNoResults = new MEditor(MPos.pos(MViewSearchRes.this, "||p,||p"));
                    MViewSearchRes.this.mNoResults.addHyperlinkListener(pEvent -> {
                        if (pEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            String desc = pEvent.getDescription();
                            if (desc.equals("mguiStrList")) {
                                ViewManager.displayLeftMenu(ViewManager.VIEW_PROJECT_LISTS);
                            } else if (desc.equals("mguiAllStrs")) {
                                ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, "[all]", ESearchMode.SEARCH_ALL);
                            } else if (desc.equals("mguiRdmStrs")) {
                                ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, "[random]", ESearchMode.SEARCH_ALL);
                            } else if (desc.equals("mguiRdmSearch")) {
                                Search.rdmSearch("", ViewManager.SEARCH_MANAGER.mSetSrc, ViewManager.SEARCH_MANAGER.mSetBlocks, ViewManager.SEARCH_MANAGER.mSetArea);
                            }
                        }
                    });
                }
                MViewSearchRes.this.mNoResults.rep("noSearchRes", ViewManager.SEARCH_MANAGER.getQuery());
                MViewSearchRes.this.mNoResults.setVisible(true);
            }

            @Override
            protected void showResults() {
                if (MViewSearchRes.this.mNoResults != null) {
                    MViewSearchRes.this.mNoResults.setVisible(false);
                }
            }
        };
        this.mSearchRes.buttonsPage(MPos.pos(this, "||p,]]p<25>"));
        this.mResStats = new MText(MPos.pos(panelBelow, "[[<>p,||<>p<>"));
        this.mSearchRes.buttonsResType(MPos.pos(panelBelow, "]]p<>,||<>p<>"));
    }

    private MPanel initHeader() {
        MFlowPanel panel = new MFlowPanel((MMPos)MPos.pos(this, "||<>m<>,[[<>86<>"), MCon.colorFrame());
        ImageIcon icon = ImgUtil.getAppIcon("str_explorer_small");
        FontMetrics metrics = MSchemeFont.getMetrics(MSchemeFont.font(15, 1));
        int[] widths = new int[MENU_TITLES.length];
        this.mMinDisplayWidth = icon.getIconWidth() + 4 * MCon.defaultGap();
        this.mMinDisplayWidth += Util.getWidth(MCon.fontButton(), MLangManager.get("to.searchSetHide")) + 50;
        for (int i = 0; i < widths.length; ++i) {
            widths[i] = Util.getWidth(metrics, MLangManager.get("bu." + MENU_TITLES[i])) + 35;
            this.mMinDisplayWidth += widths[i];
        }
        int gapLeft = 30 + icon.getIconWidth();
        int gapRight = 30 + MCon.defaultGap();
        int max = Math.max(this.mMinDisplayWidth, 850);
        String posSeach = "||<" + gapLeft + ">M" + max + '<' + gapRight + ">,[[70<>";
        this.mSearchBar = new MPanel(MPos.pos(panel, posSeach), MCon.colorFrame());
        new MPicture(MPicPos.pos("][p,[[<>p<>", this.mSearchBar), icon);
        String posPanelBelow = "||<" + gapLeft + ">M" + max + '<' + gapRight + ">,[[<86>49<>";
        MToggle toggle = new MToggle(LPos.pos(this, "]]p<25>,[[<51>34<>", 3), this.mSearchSettingsShown){

            @Override
            public void setBounds(int x, int pY, int width, int height) {
                pY = ViewManager.getScroll().attachHeader(51, pY);
                super.setBounds(x, pY, width, height);
            }
        }.title("searchSet");
        toggle.addActionListener(pEvent -> {
            this.mSearchSettingsShown = toggle.isSelected();
            this.mPanelSettings.setVisible(this.mSearchSettingsShown);
            toggle.title(this.mSearchSettingsShown ? "searchSetHide" : "searchSet");
            this.update();
        });
        return new MPanel(MPos.pos(this, posPanelBelow), MCon.colorFrame());
    }

    private void initMenu(@NotNull MPanel pPanel) {
        ActionListener[] listeners = new ActionListener[MENU_TITLES.length];
        for (int i = 0; i < MENU_TITLES.length; ++i) {
            int finalI = i;
            listeners[i] = pEvent -> {
                if (ViewManager.SEARCH_MANAGER.getMode().getUID() != finalI) {
                    ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, ViewManager.SEARCH_MANAGER.getQuery(), ESearchMode.values()[finalI]);
                    ViewManager.displayLeftMenu(this, finalI);
                }
            };
        }
        this.mMenu = new MMenuHorizontal(MPos.pos(pPanel, "[[<>m<>,]]<>35<>"), listeners, MENU_TITLES, false);
        new MPanel(MPos.pos("V||<20>m<20>,[]<>1<>", this.mSearchBar), MCon.colorTitleLine());
    }

    private void panelSettings() {
        String[] sources = MLangManager.prefix("c.", "projs", "titles", "tagss", "urls");
        String[] blocks = MLangManager.prefix("c.", "nr", "b1s", "b2s", "b3s", "b4s", "b5s");
        String[] area = MLangManager.prefix("c.", "nr", "a1", "a2", "a3", "a4", "a5");
        String[] sort = MLangManager.prefix("i.", "rnk", "blk", "are", "dls", "vws", "fav", "dia", "com", "udt", "pst");
        int comboWidth = Util.getWidth(MCon.fontCombo(), new String[][]{sources, blocks, area, sort}) + 45;
        String posCombo = "V]]" + comboWidth + ",[]s";
        this.mPanelSettings = new MFlowPanel(MPos.pos(this, "]]<>M300<10>,[[<130>1000"), 130, MCon.colorFrame());
        final SearchManager manager = ViewManager.SEARCH_MANAGER;
        Runnable after = () -> this.applySettings(manager);
        MTitle tiFilter = new MTitle(MPos.pos(this.mPanelSettings, "[[<>m<>,[[p")).title("filter");
        tiFilter.setFont(MCon.fontText());
        MCombo cSrcs = manager.mSetSrc.addComp(new MCombo(MPos.pos(posCombo, tiFilter)){

            @Override
            public void deinitialize() {
                manager.mSetSrc.remove(this);
            }
        }.text(sources), after);
        new MText(MPos.pos("[[p,||p", tiFilter, cSrcs)).title("searchSrc");
        MCombo cBlocks = manager.mSetBlocks.addComp(new MCombo(MPos.pos(posCombo, cSrcs)){

            @Override
            public void deinitialize() {
                manager.mSetBlocks.remove(this);
            }
        }.text(blocks), after);
        new MText(MPos.pos("[[p,||p", tiFilter, cBlocks)).title("numBlk");
        MCombo cArea = manager.mSetArea.addComp(new MCombo(MPos.pos(posCombo, cBlocks)){

            @Override
            public void deinitialize() {
                manager.mSetArea.remove(this);
            }
        }.text(area), after);
        new MText(MPos.pos("[[p,||p", tiFilter, cArea)).title("area");
        MTitle tiSort = new MTitle(MPos.pos("[[<>m<>,[]<27>p", tiFilter, cArea)).title("sort");
        tiSort.setFont(MCon.fontText());
        MCombo mCompSort = manager.mSetSort.addComp(new MCombo(MPos.pos(posCombo, tiSort)){

            @Override
            public void deinitialize() {
                manager.mSetSort.remove(this);
            }
        }.text(sort), after);
        new MText(MPos.pos("V[[p,||p", mCompSort)).title("srt");
        ButtonGroup group = new ButtonGroup();
        MRadio rDesc = new MRadio(MPos.pos("[[<>p,[]p", mCompSort), group){

            @Override
            public void deinitialize() {
                manager.mSetSortDesc.remove(this);
            }
        }.title("descs");
        manager.mSetSortDesc.addComp(rDesc, after);
        MRadio rAsc = new MRadio(MPos.pos("[[<>p,[]p<>", mCompSort, rDesc), group).title("ascs");
        if (manager.mSetSortDesc.isValue()) {
            rDesc.select();
        } else {
            rAsc.select();
        }
        MTitle tiOther = new MTitle(MPos.pos("[[<>m<>,[]<27>p", tiFilter, rAsc)).text("Results per Page");
        tiOther.setFont(MCon.fontText());
        int start = (Integer)CSettings.SETTING_RES_QUANTITY.getValue();
        MSlider resQuantity = new MSlider(MPos.pos("V]]M200,[]40", tiOther), 25, 250, start);
        resQuantity.addTicks();
        resQuantity.addLabels(25, 50, 100, 150, 200, 250);
        resQuantity.addListener(pEvent -> {
            CSettings.SETTING_RES_QUANTITY.setValue(resQuantity.getValue());
            this.applySettings(manager);
        });
        CSettings.SETTING_RES_QUANTITY.registerObserver(pSetting -> resQuantity.setValue((Integer)pSetting.getValue()));
        new MButton(MPos.pos("V]]p,[]<35>30<>", resQuantity)).addAction(pEvent -> {
            manager.resetSettings();
            CSettings.SETTING_RES_QUANTITY.setDefaultValue();
            this.applySettings(manager);
        }).title("defSet");
        this.mPanelSettings.setVisible(false);
    }

    private void applySettings(@NotNull SearchManager pManager) {
        pManager.search(ViewManager.VIEW_SEARCH_RES, pManager.getQuery(), ViewManager.SEARCH_MANAGER.getMode());
        this.mSearchRes.actPref();
    }

    @Override
    protected void displayState(Integer pMode) {
        if (pMode != -1) {
            this.mMode = pMode;
        }
        this.mMenu.setActivated(this.mMode);
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return (Object)((Object)EURI.PRE_BROWSE) + "search/" + URIS[this.mMode];
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_SEARCH_RES;
    }

    @Override
    public int getMenuButton() {
        return 0;
    }

    public ViewRes getSearchRes() {
        return this.mSearchRes;
    }

    public MField getFieldSearch() {
        return this.mFieldSearch;
    }

    public MText getResStats() {
        return this.mResStats;
    }

    public MEditor getNoResults() {
        return this.mNoResults;
    }
}

