/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.manager.MAnalyticsUtil;
import de.maggicraft.ism.analytics.util.ESearchMode;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.MMenuHorizontal;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.search.SearchManager;
import de.maggicraft.ism.views.EViewSetting;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MHeader;
import de.maggicraft.mgui.comp.MRadio;
import de.maggicraft.mgui.comp.MSlider;
import de.maggicraft.mgui.comp.MSwitcher;
import de.maggicraft.mgui.comp.MTable;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.settings.MSettingGui;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MViewSettings
extends MISMView<EViewSetting> {
    private static final String[] MENU_TITLES = new String[]{"setGen", "setSearch", "setPriv"};
    private MMenuHorizontal mHeader;
    private EViewSetting mState = EViewSetting.SETTINGS_GENERAL;
    @Nullable
    private MCombo mMCClosed;

    @Override
    public void initialize() {
        ActionListener[] listeners = new ActionListener[]{pEvent -> ViewManager.displayLeftMenu(this, EViewSetting.SETTINGS_GENERAL), pEvent -> ViewManager.displayLeftMenu(this, EViewSetting.SETTINGS_SEARCH), pEvent -> ViewManager.displayLeftMenu(this, EViewSetting.SETTINGS_PRIVACY)};
        this.mHeader = new MMenuHorizontal(LPos.pos(this, "[[<15>m,[[<>61<>", 6), listeners, MENU_TITLES){

            @Override
            public void setBounds(int pX, int pY, int pWidth, int pHeight) {
                pY = ViewManager.getScroll().attachHeader(0, pY);
                super.setBounds(pX, pY, pWidth, pHeight);
            }
        };
    }

    @Override
    protected void displayState(@NotNull EViewSetting pState) {
        this.mState = pState;
        this.mHeader.setActivated(this.mState.getID());
        if (this.mState == EViewSetting.SETTINGS_GENERAL) {
            this.displaySettingsGeneral();
        } else if (this.mState == EViewSetting.SETTINGS_SEARCH) {
            this.displaySettingsSearch();
        } else if (this.mState == EViewSetting.SETTINGS_PRIVACY) {
            this.displaySettingsPrivacy();
        } else {
            throw new IllegalArgumentException("illegal mode " + this.mState);
        }
    }

    private void displaySettingsGeneral() {
        MPanel panel = new MPanel(MPos.pos(this, "||<30>M750<30>,[[<76>1000"), MCon.colorFrame());
        MTitle tiDisplay = new MTitle(MPos.pos(panel, "[[<>m<>,[[p")).title("dis");
        tiDisplay.setFont(MCon.fontText());
        MCombo coOpenWin = MSettingGui.compOptions(CSettings.SETTING_OPEN_WIN, MPos.pos("]]p,[]s", tiDisplay));
        new MText(MPos.pos("[[p,||p", tiDisplay, coOpenWin)).title("opWin");
        MSwitcher swShowTips = MSettingGui.switcherBool(CSettings.SETTING_SHOW_TIPS, MPos.pos("]]p<>,[]p", coOpenWin), "");
        new MText(MPos.pos("[[p,||p", tiDisplay, swShowTips)).text(MLangManager.get("se.showTips"));
        this.mMCClosed = MSettingGui.compOptions(CSettings.SETTING_MINECRAFT_CLOSED, MPos.pos("]]p<>,[]p", swShowTips));
        new MText(MPos.pos("[[p,||p", tiDisplay, this.mMCClosed)).title("setMCClosed");
        MTitle tiGame = new MTitle(MPos.pos("[[<>m<>,[]<27>p", tiDisplay, this.mMCClosed)).title("game");
        tiGame.setFont(MCon.fontText());
        MCombo coDropExpl = MSettingGui.compOptions(CSettings.SETTING_DROP_EXPLORER, MPos.pos("]]p,[]s", tiGame));
        MText teDropExpl = new MText(MPos.pos("[[p,||p", tiGame, coDropExpl)).title("dropExpl");
        MSwitcher sDropSurvi = MSettingGui.switcherBool(CSettings.SETTING_DROP_SURVIVAL, MPos.pos("]]p,[]<20>p", tiGame, teDropExpl), "");
        new MText(MPos.pos("[[p,||p", tiGame, sDropSurvi)).title("dropSurvi");
        MTitle tiStrs = new MTitle(MPos.pos("[[<>m<>,[]<27>p", tiGame, sDropSurvi)).title("strSet");
        tiStrs.setFont(MCon.fontText());
        MSwitcher sFlattenArea = MSettingGui.switcherBool(CSettings.SETTING_FLATTEN_AREA, MPos.pos("]]p,[]p", tiStrs), "");
        new MText(MPos.pos("[[p,||p", tiStrs, sFlattenArea)).title("flattenArea");
        new MButton(MPos.pos("V[[<>p<>,[]<35>30<>", sFlattenArea)).addAction(pEvent -> CSettings.getSettings().setDefaultValues()).title("defSet");
        this.setDim(600, 495);
    }

    private void displaySettingsSearch() {
        String[] sources = MLangManager.prefix("c.", "projl", "titlel", "tagsl", "urll");
        String[] blocks = MLangManager.prefix("c.", "nr", "b1l", "b2l", "b3l", "b4l", "b5l");
        String[] area = MLangManager.prefix("c.", "nr", "a1", "a2", "a3", "a4", "a5");
        String[] sort = MLangManager.prefix("i.", "rnk", "blk", "are", "dls", "vws", "fav", "dia", "com", "udt", "pst");
        int comboWidth = Util.getWidth(MCon.fontCombo(), new String[][]{sources, blocks, area, sort}) + 45;
        String posCombo = "V]]" + comboWidth + ",[]s";
        MPanel panel = new MPanel(MPos.pos(this, "||<30>M750<30>,[[<76>1000"), MCon.colorFrame());
        final SearchManager manager = ViewManager.SEARCH_MANAGER;
        MTitle tiFilter = new MTitle(MPos.pos(panel, "[[<>m<>,[[p")).title("filter");
        tiFilter.setFont(MCon.fontText());
        MCombo cSrc = manager.mSetSrc.addComp(new MCombo(MPos.pos(posCombo, tiFilter)){

            @Override
            public void deinitialize() {
                manager.mSetSrc.remove(this);
            }
        }.text(sources));
        new MText(MPos.pos("[[p,||p", tiFilter, cSrc)).title("searchSrc");
        MCombo cBlocks = manager.mSetBlocks.addComp(new MCombo(MPos.pos(posCombo, cSrc)){

            @Override
            public void deinitialize() {
                manager.mSetBlocks.remove(this);
            }
        }.text(blocks));
        new MText(MPos.pos("[[p,||p", tiFilter, cBlocks)).title("numBlk");
        MCombo cArea = manager.mSetArea.addComp(new MCombo(MPos.pos(posCombo, cBlocks)){

            @Override
            public void deinitialize() {
                manager.mSetArea.remove(this);
            }
        }.text(area));
        new MText(MPos.pos("[[p,||p", tiFilter, cArea)).title("area");
        MTitle tiSort = new MTitle(MPos.pos("[[<>m<>,[]<27>p", tiFilter, cArea)).title("sort");
        tiSort.setFont(MCon.fontText());
        MCombo cSort = new MCombo(MPos.pos(posCombo, tiSort)){

            @Override
            public void deinitialize() {
                manager.mSetSrc.remove(this);
            }
        }.text(sort);
        new MText(MPos.pos("V[[p,||p", cSort)).title("srt");
        manager.mSetSrc.addComp(cSort);
        ButtonGroup group = new ButtonGroup();
        MRadio rDesc = new MRadio(MPos.pos("[[<>p,[]p", cSort), group){

            @Override
            public void deinitialize() {
                manager.mSetSortDesc.remove(this);
            }
        }.title("descl");
        manager.mSetSortDesc.addComp(rDesc);
        MRadio rAsc = new MRadio(MPos.pos("[[<>p,[]p<>", cSort, rDesc), group).title("ascl");
        if (manager.mSetSortDesc.isValue()) {
            rDesc.select();
        } else {
            rAsc.select();
        }
        MTitle tiOther = new MTitle(MPos.pos("[[<>m<>,[]<27>p", tiFilter, rAsc)).title("othSet");
        tiOther.setFont(MCon.fontText());
        int start = (Integer)CSettings.SETTING_RES_QUANTITY.getValue();
        MSlider resQuantity = new MSlider(MPos.pos("V]]" + comboWidth + ",[]40", tiOther), 25, 250, start);
        resQuantity.addTicks();
        resQuantity.addLabels(25, 50, 100, 150, 200, 250);
        resQuantity.addListener(pEvent -> CSettings.SETTING_RES_QUANTITY.setValue(resQuantity.getValue()), true);
        CSettings.SETTING_RES_QUANTITY.registerObserver(pSetting -> resQuantity.setValueVoid(pSetting.getValue()));
        new MText(MPos.pos("V[[p,||p", resQuantity)).title("resPP");
        new MButton(MPos.pos("V[[p<>,[]<35>30<>", resQuantity)).addAction(pEvent -> {
            manager.resetSettings();
            CSettings.SETTING_RES_QUANTITY.setDefaultValue();
        }).title("defSet");
        MButton bAdvSearch = new MButton(MPos.pos("V]]<>p,[]<35>30<>", resQuantity)).addAction(pEvent -> {
            manager.search(ViewManager.VIEW_SEARCH_RES, manager.getQuery(), ESearchMode.SEARCH_ALL);
            ViewManager.VIEW_SEARCH_RES.getSearchRes().actPref();
        }).title("advSearch");
        bAdvSearch.setEnabled(manager.getQuery() != null);
        this.setDim(cSort.getX() + cSort.getWidth() + 20, 610);
    }

    private void displaySettingsPrivacy() {
        MEditor edIntro = new MEditor(MPos.pos(this, "[[<30>m<45>,[[<76>p")).title("ps");
        MTable[] tables = new MTable[MAnalyticsUtil.TABLE_LEN.length];
        MAnalyticsUtil.setTables(tables);
        int wid = Util.getWidth(MLangManager.get("te.preSet")) + 30;
        MCombo coPreset = new MCombo(MPos.pos("[[<" + wid + ">p,[]s<45>", this.mHeader, edIntro)).title("preSet0", "preSet1", "preSet2", "preSet3");
        MAnalyticsUtil.setComboPreset(coPreset);
        coPreset.setSelectedIndex(3 - (Integer)MAnalyticsSettings.SETTING_PRESET.getValue());
        coPreset.addListener(pEvent -> {
            int selected = coPreset.getSelectedIndex();
            if (selected > 0) {
                MAnalyticsSettings.setPreset(3 - selected);
            }
        });
        new MText(MPos.pos("][p,||p", coPreset)).title("preSet");
        final MText[] texts = new MText[5];
        JComponent last = coPreset;
        for (int i = 1; i < 5; ++i) {
            final int tab = i - 1;
            MFlowPanel flowPanel = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)((Object)last), i), 61, MCon.colorFrame());
            new MTitle(MPos.pos(flowPanel, "[[m,]]<>p<>")).title("ps" + i);
            final int finalI = i;
            MPanel panelText = new MPanel(LPos.pos("V[[<>m<>,[]<70>30", (IComp)((Object)last), finalI), MCon.colorFrame()){

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    if (texts[finalI] != null && texts[finalI].getPos() != null) {
                        height = texts[finalI].getPos().getPrefHeight() + MCon.defaultGap();
                    }
                    super.setBounds(x, y, width, height);
                }
            };
            texts[i] = new MText(MPos.pos(panelText, "[[<30>m<30>,[[p<>")).title("ps" + i);
            last = panelText;
            MFlowPanel flowTableHeader = new MFlowPanel(LPos.pos("V[[<>m<>,[]<>45", (IComp)((Object)last), i), 106, MCon.colorFrame());
            MHeader header = new MHeader(LPos.pos(flowTableHeader, "[[<30>m<30>,]]<>30<>"));
            tables[tab] = new MTable(MPos.pos("V[[<30>m<30>,[]<45>p<30>", last), header){

                @Override
                @NotNull
                public TableModel createTableModel() {
                    return new DefaultTableModel(this.getContent(), this.getHeader().getHeader()){

                        @Override
                        public boolean isCellEditable(int pRow, int pColumn) {
                            return pColumn == 3;
                        }
                    };
                }

                @NotNull
                public Class getColumnClass(int pCol) {
                    return pCol == 3 ? Boolean.class : String.class;
                }

                @Override
                public Object populateContent(String pTitle, int pRow, int pCol) {
                    if (pCol == 3) {
                        return MAnalyticsSettings.isEnabled(MAnalyticsUtil.MEASURES[tab][pRow]);
                    }
                    return super.populateContent(pTitle, pRow, pCol);
                }

                @Override
                public void updateMinWidth() {
                    TableColumnModel model = this.getColumnModel();
                    if (model.getColumnCount() == 4) {
                        TableColumn col3 = model.getColumn(3);
                        col3.setMinWidth(this.prefWidthColumn(3));
                    }
                }
            }.title("tab" + i, "head", MAnalyticsUtil.TABLE_LEN[tab], 4).relativeWidth(0.2f, 0.4f, 0.4f, 0.0f);
            last = tables[tab];
            MAnalyticsUtil.TABLE_IDS[tab] = tables[tab].getId();
        }
        ViewManager.VIEW_SETTINGS.setDim(tables[tables.length - 1], 700);
    }

    public void updateMCClosed() {
        if (this.mMCClosed != null) {
            int selectedIndex = CSettings.SETTING_MINECRAFT_CLOSED.getSelectedIndex();
            if (this.mMCClosed.getSelectedIndex() != selectedIndex) {
                this.mMCClosed.setSelectedIndex(selectedIndex);
            }
        }
    }

    public EViewSetting getState() {
        return this.mState;
    }

    @Override
    public EViewSetting getDefaultState() {
        return this.mState;
    }

    @Override
    public void afterDisplay(EViewSetting pState) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return "settings/" + this.mState.getURI();
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_SETTINGS;
    }

    @Override
    public int getMenuButton() {
        return 4;
    }
}

