/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.trackers.TrackControlledPage;
import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.MMenuHorizontal;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MPictureMode;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MViewTutorials
extends MISMView<Integer> {
    public static final String TUT_PLACE_STR = "plcStr";
    static final String TUT_SCAN_STR = "scnStr";
    static final String TUT_REPOS_STR = "repStr";
    static final String TUT_REMOVE_STR = "remStr";
    static final String TUT_PLACE_SHAPE = "plcShp";
    private static final String[] MENU_TITLES = new String[]{"vTuts", "vCrft"};
    private static final String[] URIS = new String[]{"tutorials/", "crafting/"};
    private static final String[] TUTORIALS = new String[]{"strExpl", "plcStr", "scnStr", "repStr", "remStr", "plcShp"};
    private static final String[] CRAFTING = new String[]{"b_green", "b_red", "i_bb_1", "i_bb_2", "i_expl", "i_place", "i_remove", "i_repos", "i_shape"};
    private static final int TUT_TUTORIALS = 0;
    private static final int TUT_CRAFTING = 1;
    private int mMode = 0;
    private MMenuHorizontal mHeader;

    @Override
    public void initialize() {
        ActionListener[] listeners = new ActionListener[]{pEvent -> ViewManager.displayLeftMenu(this, 0), pEvent -> ViewManager.displayLeftMenu(this, 1)};
        this.mHeader = new MMenuHorizontal(LPos.pos(this, "[[<15>m,[[<>61<>", 1), listeners, MENU_TITLES){

            @Override
            public void setBounds(int pX, int pY, int pWidth, int pHeight) {
                pY = ViewManager.getScroll().attachHeader(0, pY);
                super.setBounds(pX, pY, pWidth, pHeight);
            }
        };
    }

    @Override
    protected void displayState(Integer pMode) {
        if (pMode != -1) {
            this.mMode = pMode;
        }
        this.mHeader.setActivated(this.mMode);
        if (this.mMode == 0) {
            JComponent last = new MEditor(MPos.pos(this, "[[<30>m,[[<76>p")).title("tut");
            int wid = Util.getWidth(MCon.fontButton(), MLangManager.get("bu.openTut"));
            String buttonPos = "[[p<" + (wid += 50 + 2 * MCon.defaultGap()) + ">,[]<10>p<20>";
            for (String tutorial : TUTORIALS) {
                last = new MTitle(MPos.pos("V[[m,[]<20>p", last)).title(tutorial);
                String url = "tutorials/" + MLangManager.get("tutURL." + tutorial);
                ActionListener openURL = TrackControlledPage.utmURLAction(url, "", EUTMView.VIEW_TUTORIALS);
                new MButton(MPos.pos("V]]p,[]<10>s<>", last)).addAction(openURL).title("openTut");
                last = new MEditor(MPos.pos(buttonPos, last)).title(tutorial);
            }
            this.setDim((IComp)((Object)last), 600);
        } else if (this.mMode == 1) {
            MPicture last = null;
            for (int i = 0; i < CRAFTING.length; ++i) {
                LPos pos = i == 0 ? LPos.pos(this, "[[m,[[<76>46", i) : LPos.pos("V[[m,[]<20>46", last, i);
                MFlowPanel panelHeader = new MFlowPanel(pos, 61, MCon.colorFrame());
                new MTitle(MPos.pos(panelHeader, "[[<>m,]]<>p<>")).title(CRAFTING[i]);
                MPicPos posPic = i == 0 ? MPicPos.pos(this, "[[<30>236,[[<137>110") : MPicPos.pos("[[<>236,[]<81>110", last);
                last = new MPicture(posPic, ImgUtil.getAppIcon("crafting/" + CRAFTING[i]), MPictureMode.CUT);
                new MText(MPos.pos("[]p,||<>p", last)).title(CRAFTING[i]);
            }
            this.setDim(last, 500);
        } else {
            throw new IllegalArgumentException("illegal mode " + pMode);
        }
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return "tutorials/" + URIS[this.mMode];
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_TUTORIALS;
    }

    @Override
    public int getMenuButton() {
        return 3;
    }
}

