/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.trackers.TrackControlledPage;
import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.analytics.util.EUTMExternal;
import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.favorites.EFavoriteObservedOperation;
import de.maggicraft.ism.favorites.IFavorite;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.MTrackableDialog;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.results.ViewRes;
import de.maggicraft.ism.search.IResSearch;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mcommons.event.IObserver;
import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mcommons.filter.types.MFilters;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mcommons.util.MTriple;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MSwitcher;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.comp.MToggle;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.schemes.types.MSchemeFont;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mgui.view.MView;
import de.maggicraft.mgui.view.util.EWindowSize;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ViewUtil {
    @NotNull
    public static final ImageIcon ICON_RIGHT_PRESSED;
    @NotNull
    public static final ImageIcon ICON_RIGHT_ROLLOVER;
    @NotNull
    public static final ImageIcon ICON_RIGHT_ENABLED;
    @NotNull
    public static final ImageIcon ICON_RIGHT_DISABLED;
    @NotNull
    public static final ImageIcon ICON_LEFT_PRESSED;
    @NotNull
    public static final ImageIcon ICON_LEFT_ENABLED;
    @NotNull
    public static final ImageIcon ICON_LEFT_ROLLOVER;
    @NotNull
    public static final ImageIcon ICON_LEFT_DISABLED;
    @NotNull
    public static final ImageIcon ICON_MINIMAL_PRESSED;
    @NotNull
    public static final ImageIcon ICON_MINIMAL_ROLLOVER;
    @NotNull
    public static final ImageIcon ICON_MINIMAL_ENABLED;
    @NotNull
    public static final ImageIcon ICON_MINIMAL_DISABLED;
    @NotNull
    public static final ImageIcon ICON_DETAILED_PRESSED;
    @NotNull
    public static final ImageIcon ICON_DETAILED_ENABLED;
    @NotNull
    public static final ImageIcon ICON_DETAILED_ROLLOVER;
    @NotNull
    public static final ImageIcon ICON_DETAILED_DISABLED;
    public static final Color COLOR_ARROW_ENABLED;
    static final Font FONT_TITLE_HOVER;
    static final MFilter WORLD_HEIGHT;
    static final MFilter WORLD_SIZE;
    private static final ImageIcon ICON_FAV;
    private static final ImageIcon ICON_FAV_HOVER;
    private static final ImageIcon ICON_FAV_PRESSED;
    private static final ImageIcon ICON_FAV_HOVER_BROKEN;
    private static final ImageIcon ICON_PROJECT;
    private static final ImageIcon ICON_PROJECT_HOVER;
    private static final ImageIcon ICON_PROJECT_PRESSED;
    private static final ImageIcon ICON_CRE;
    private static final ImageIcon ICON_CRE_HOVER;
    private static final ImageIcon ICON_CRE_PRESSED;
    private static final Color COLOR_ARROW_ROLLOVER;
    private static final Color COLOR_ARROW_DISABLED;
    private static final Color COLOR_ARROW_PRESSED;
    private static final int THIRD = 21;

    private ViewUtil() {
    }

    @NotNull
    static MTriple<MToggle, IObserver<IFavorite>, IObserver<IFavorite>> buttonFav(@NotNull MPos pPos, IProject pProject) {
        boolean isFavorite = ISMContainer.getFavoritesManager().isFavorite(pProject);
        final MToggle toggle = new MToggle(pPos, isFavorite, ICON_FAV, ICON_FAV_PRESSED, ICON_FAV_HOVER, ICON_FAV_HOVER_BROKEN, ICON_FAV_PRESSED);
        toggle.addActionListener(pEvent -> ISMContainer.getFavoritesManager().favor(pProject));
        final MText text = ViewUtil.roundButtonLabel(toggle, isFavorite ? "defav" : "fav", LabelAlign.BOTTOM);
        String tip = pProject.isCollection() ? "Col" : "Proj";
        final MTip tipFav = new MTip(MLangManager.get("tip.fav" + tip));
        final MTip tipDefavor = new MTip(MLangManager.get("tip.defav" + tip));
        toggle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent pEvent) {
                toggle.setPressedIcon(toggle.isSelected() ? ICON_FAV : ICON_FAV_PRESSED);
                toggle.tip(toggle.isSelected() ? tipFav : tipDefavor);
                text.title(toggle.isSelected() ? "fav" : "defav");
            }
        });
        toggle.tip(toggle.isSelected() ? tipDefavor : tipFav);
        IObserver<IFavorite> observerAdded = pFavorite -> {
            if (pProject.getPID() == pFavorite.getPID()) {
                toggle.setSelected(true);
            }
        };
        ISMContainer.getFavoritesManager().registerObserver(EFavoriteObservedOperation.FAVORITE_ADDED, observerAdded);
        IObserver<IFavorite> observerRemoved = pFavorite -> {
            if (pProject.getPID() == pFavorite.getPID()) {
                toggle.setSelected(false);
            }
        };
        ISMContainer.getFavoritesManager().registerObserver(EFavoriteObservedOperation.FAVORITE_REMOVED, observerRemoved);
        return new MTriple<MToggle, IObserver<IFavorite>, IObserver<IFavorite>>(toggle, observerAdded, observerRemoved);
    }

    @NotNull
    static MButton buttonProject(@NotNull MPos pPos, IProject pProject, @NotNull EUTMExternal pUTM) {
        String tip = pProject instanceof ICollection ? "Col" : "Proj";
        MButton button = new MButton(pPos, ICON_PROJECT, ICON_PROJECT_HOVER, ICON_PROJECT_PRESSED);
        button.addAction(pEvent -> SharedUtil.openProject(pProject, pUTM)).tip(new MTip(MLangManager.get("tip.open" + tip)));
        ViewUtil.roundButtonLabel(button, "source", LabelAlign.BOTTOM);
        return button;
    }

    @NotNull
    static MButton buttonCre(@NotNull MPos pPos, @NotNull ICreator pCreator, @NotNull EUTMExternal pUTM) {
        MButton button = new MButton(pPos, ICON_CRE, ICON_CRE_HOVER, ICON_CRE_PRESSED);
        button.addAction(pEvent -> SharedUtil.openCreator(pCreator, pUTM)).tip(new MTip(MLangManager.get("tip.openCre")));
        ViewUtil.roundButtonLabel(button, "creator", LabelAlign.BOTTOM);
        return button;
    }

    @NotNull
    public static MText roundButtonLabel(@NotNull IComp pComp, @Nullable String pTitle, @NotNull LabelAlign pAlign) {
        MText text = new MText(MPos.pos(pAlign.mPos, pComp)){};
        text.setOpaque(true);
        text.setBackground(MCon.colorAccent());
        if (pTitle != null) {
            text.title(pTitle);
        }
        return text;
    }

    @NotNull
    static MText titleSelectable(@NotNull MPos pPos, @NotNull String pTitle, final @NotNull Runnable pAction) {
        final MText text = new MText(pPos).text(pTitle);
        text.setForeground(MCon.colorTitleText());
        text.setFont(MCon.fontTitle());
        text.setCursor(CSharedCon.CURSOR_HAND);
        text.setLineWrap(false);
        text.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent pEvent) {
                pAction.run();
            }

            @Override
            public void mouseEntered(MouseEvent pEvent) {
                text.setFont(FONT_TITLE_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent pEvent) {
                text.setFont(MCon.fontTitle());
            }
        });
        return text;
    }

    static void titleTutorial(@NotNull IView pView, @NotNull String pTutorial, @NotNull EUTMView pTrackingCode) {
        MFlowPanel panelHeader = new MFlowPanel((MMPos)LPos.pos(pView, "[[<>m<>,[[<>61", 1), MCon.colorFrame());
        MButton bTut = ViewUtil.tutorialButton(panelHeader, pTutorial, pTrackingCode);
        new MTitle(MPos.pos("H][m,]]<>p<>", bTut)).title(pTutorial);
    }

    @NotNull
    static MButton tutorialButton(@NotNull IView pView, final String pTutorial, final @NotNull EUTMView pTrackingCode) {
        final MTip tip = new MTip(MLangManager.rep("bu.tt.opnTut", MLangManager.get("tut." + pTutorial)));
        return new MButton(MPos.pos(pView, "]]p,]]s<>")).addAction(pEvent -> new MTrackableDialog(ISMContainer.getStrExplorer().getFrame(), EWindowSize.THREE){

            @Override
            public void init(@NotNull MDialog pView) {
                new MText(MPos.pos(pView, "||m,||m<60>")).rep("opnTut", MLangManager.get("tut." + pTutorial));
                MButton button = new MButton(MPos.pos(pView, "]]p,]]s")).defButton().title("opnTut").tip(tip);
                button.addAction(pEvent -> TrackControlledPage.utmURLAction("tutorials/" + MLangManager.get("tutURL." + pTutorial), "", pTrackingCode));
            }

            @Override
            public void afterInit() {
                SwingUtilities.invokeLater(this::afterDisplay);
            }

            @Override
            @NotNull
            protected String getURI() {
                return (Object)((Object)EURI.DIALOG) + "tutorial/";
            }
        }.title("opnTut").visible()).title("opnTut").tip(tip);
    }

    @NotNull
    static ViewRes initStrView(final @NotNull MView pView, String pTitle, final int pMinWidth) {
        MPanel header = ViewUtil.header(pView, MLangManager.get("te." + pTitle));
        ViewRes viewRes = new ViewRes(MPos.pos(pView, "||<>m<>,[[<106>p"), ViewManager.getScroll(), CSettings.SETTING_VIEW_STRUCTURES, true){

            @Override
            public void actPrefDim(int pWidth, int pHeight) {
                pView.setDim(Math.max(pWidth, pMinWidth), pHeight + 170);
            }

            @Override
            public int getSort() {
                return 0;
            }
        };
        viewRes.buttonsResType(MPos.pos(header, "]]p<30>,]]p<5>"));
        viewRes.buttonsPage(MPos.pos(pView, "||p,]]p<25>"));
        ISMContainer.getStrExplorer().getFrame().validate();
        ViewManager.getScroll().repaint();
        return viewRes;
    }

    @NotNull
    static MButton headerTutorial(@NotNull MView pView, @NotNull String pTitle, String pTutorial, EUTMView pCode) {
        MFlowPanel header = new MFlowPanel((MMPos)LPos.pos(pView, "[[<>m<>,[[<>61", 1), MCon.colorFrame());
        MButton bTut = ViewUtil.tutorialButton(header, pTutorial, pCode);
        MText title = new MText(MPos.pos(header, "[[<30>p,]]<>p<5>")).text(pTitle);
        title.setForeground(MCon.colorTitleText());
        title.setFont(MCon.fontTitle());
        new MPanel(MPos.pos("][m,]]1<>", bTut), MCon.colorTitleLine());
        return bTut;
    }

    @NotNull
    public static MPanel header(@NotNull MView pView, @NotNull String pTitle) {
        MFlowPanel header = new MFlowPanel((MMPos)LPos.pos(pView, "[[<>m<>,[[<>61", 1), MCon.colorFrame());
        MText title = new MText(MPos.pos(header, "[[<30>p,]]<>p<5>")).text(pTitle);
        title.setForeground(MCon.colorTitleText());
        title.setFont(MCon.fontTitle());
        new MPanel(MPos.pos(header, "[[m,]]1<>"), MCon.colorTitleLine());
        return header;
    }

    static void initFilter(@NotNull MView pView, @NotNull ViewRes pViewRes) {
        MFlowPanel panelFilter = new MFlowPanel(LPos.pos(pView, "[[<>m<>,[[<61>60", 1), 61, MCon.colorFrame());
        ViewUtil.initFilter(pView, 121, MPos.pos(panelFilter, "||<30>M850<30>,||<>30<>"), pViewRes);
    }

    public static void initFilter(@NotNull MView pView, int pGap, @NotNull MPos pPos, @NotNull ViewRes pViewRes) {
        MPanel panelFilter = new MPanel(pPos, MCon.colorFrame());
        MButton buRemove = new MButton(MPos.pos(panelFilter, "]]<>p<>,[[<>m<>")).title("clean");
        MField field = new MField(MPos.pos("H][<>m,[[<>m<>", buRemove)).title("flt");
        MPanel panelNoRes = new MPanel(LPos.pos(pView, "||<30>M850<30>,[[<" + pGap + ">30", 2), MCon.colorFrame());
        MText tNoRes = new MText(MPos.pos(panelNoRes, "[[<>p<>,||<>p<>"));
        MText tRemoveFilter = new MText(MPos.pos("H[]<>p<>,||<>p<>", tNoRes)).title("remFilter");
        panelNoRes.setVisible(false);
        buRemove.addActionListener(pEvent -> {
            panelNoRes.setVisible(false);
            pViewRes.setFilterActivated(false);
            field.title("flt");
            pViewRes.resetFilter();
            pViewRes.displayResPage();
            pViewRes.setFilterActivated(true);
        });
        SharedUtil.addLink(tRemoveFilter, () -> {
            buRemove.requestFocus();
            buRemove.doClick();
        });
        field.addListener(pEvent -> {
            if (!pViewRes.isFilterActivated()) {
                return;
            }
            if (field.getText().isEmpty() || field.getText().equals(field.getPlaceholder())) {
                pViewRes.resetFilter();
                pViewRes.displayResPage();
            } else {
                ViewUtil.update(tNoRes, field, pViewRes, panelNoRes);
            }
        });
    }

    private static void update(@NotNull MText pNoRes, @NotNull MField pField, @NotNull ViewRes pViewRes, @NotNull MPanel pPanelNoRes) {
        boolean changed = pViewRes.filter(pField.getText());
        pViewRes.setHighlightText(pField.getText());
        if (changed) {
            pViewRes.setPage(0);
            pViewRes.displayResPage();
        }
        for (IResSearch res : pViewRes.getSearchRes()) {
            res.mark(pField.getText());
        }
        if (pViewRes.getSearchRes().isEmpty()) {
            pNoRes.rep("noRes", pField.getText());
            pPanelNoRes.setVisible(true);
        } else {
            pPanelNoRes.setVisible(false);
        }
    }

    static boolean isLogoutShown() {
        try {
            return ISMContainer.getWorldInfoManager().isLoggedOut();
        }
        catch (IllegalStateException pE) {
            return true;
        }
    }

    static void addInfo(@NotNull MText pText, int pInfo) {
        pText.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        new MText(MPos.pos("[]<>p,||p", pText)).text(CommonUtil.decMark(pInfo));
    }

    @NotNull
    static MText addInfo(@NotNull MText pText, @NotNull String pInfo) {
        pText.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        return new MText(MPos.pos("[]<>p,||p<>", pText)).text(pInfo);
    }

    @Nullable
    static IPos checkPos(@Nullable IPos pPos) {
        if (pPos == null) {
            return ISMContainer.getWorldInfoManager().getPlayerPos();
        }
        return pPos;
    }

    static int noteBelow(final String pURIPrefix) {
        final int[] process = new int[]{0};
        new MTrackableDialog((Frame)ISMContainer.getStrExplorer().getFrame(), EWindowSize.FOUR){

            @Override
            public void init(@NotNull MDialog pView) {
                MText text = new MText(MPos.pos(pView, "||m,[[p<60>")).title("posBelow");
                MSwitcher swBedrock = new MSwitcher(MPos.pos("V[[p,[]p", text), true).title("keepBedrock");
                new MButton(MPos.pos(pView, "[[p,]]s")).addAction(pEvent -> {
                    pView.dispose();
                    process2[0] = 0;
                }).title("cnl");
                new MButton(MPos.pos(pView, "]]p,]]s")).addAction(pEvent -> {
                    pView.dispose();
                    process2[0] = swBedrock.isSelected() ? 2 : 1;
                }).defButton().title("con");
            }

            @Override
            public void afterInit() {
                SwingUtilities.invokeLater(this::afterDisplay);
            }

            @Override
            @NotNull
            protected String getURI() {
                return pURIPrefix + (Object)((Object)EURI.DIALOG) + "note-below/";
            }
        }.title("note").setVisible(true);
        return process[0];
    }

    static MButton thumbnailButton(@NotNull MPos pPos, @NotNull IProject pProject) {
        MButton thumb = new MButton((MMPos)pPos, (Icon)CSharedCon.ICON_THUMBNAIL).addAction(pEvent -> ViewManager.displayDetail(pProject));
        thumb.setCursor(CSharedCon.CURSOR_HAND);
        new Thread(() -> {
            Optional<BufferedImage> img = SharedUtil.loadThumbnail(pProject.getPID());
            img.ifPresent(pBufferedImage -> thumb.setIcon(ImgUtil.getImg(pBufferedImage)));
        }).start();
        return thumb;
    }

    static boolean noteAbove(final String pURIPrefix) {
        final boolean[] process = new boolean[1];
        new MTrackableDialog((Frame)ISMContainer.getStrExplorer().getFrame(), EWindowSize.FOUR){

            @Override
            public void init(@NotNull MDialog pView) {
                new MText(MPos.pos(pView, "||m,||m<60>")).title("posAbove");
                new MButton(MPos.pos(pView, "[[p,]]s")).addAction(pEvent -> {
                    pView.dispose();
                    process2[0] = false;
                }).title("cnl");
                new MButton(MPos.pos(pView, "]]p,]]s")).addAction(pEvent -> {
                    pView.dispose();
                    process2[0] = true;
                }).defButton().title("con");
            }

            @Override
            public void afterInit() {
                SwingUtilities.invokeLater(this::afterDisplay);
            }

            @Override
            @NotNull
            protected String getURI() {
                return pURIPrefix + (Object)((Object)EURI.DIALOG) + "note-above/";
            }
        }.title("note").setVisible(true);
        return process[0];
    }

    static int getThird(int pPos) {
        if (pPos > 43) {
            return 2;
        }
        return pPos > 21 ? 1 : 0;
    }

    static {
        COLOR_ARROW_ENABLED = new Color(185, 185, 185);
        FONT_TITLE_HOVER = MSchemeFont.fontUnderline(MCon.fontTitle());
        WORLD_HEIGHT = MFilters.filterInt(0, 255);
        WORLD_SIZE = MFilters.filterInt(-30000000, 29999999);
        ICON_FAV = ImgUtil.getAppIcon("fav");
        ICON_FAV_HOVER = ImgUtil.getAppIcon("fav_hover");
        ICON_FAV_PRESSED = ImgUtil.getAppIcon("fav_pressed");
        ICON_FAV_HOVER_BROKEN = ImgUtil.getAppIcon("fav_hover_broken");
        ICON_PROJECT = ImgUtil.getAppIcon("proj");
        ICON_PROJECT_HOVER = ImgUtil.getAppIcon("proj_hover");
        ICON_PROJECT_PRESSED = ImgUtil.getAppIcon("proj_pressed");
        ICON_CRE = ImgUtil.getAppIcon("cre");
        ICON_CRE_HOVER = ImgUtil.getAppIcon("cre_hover");
        ICON_CRE_PRESSED = ImgUtil.getAppIcon("cre_pressed");
        COLOR_ARROW_ROLLOVER = new Color(220, 220, 220);
        COLOR_ARROW_DISABLED = new Color(100, 100, 100);
        COLOR_ARROW_PRESSED = new Color(255, 255, 255);
        Optional<BufferedImage> arrow = ImgUtil.getAppBuffered("arrow_right");
        if (!arrow.isPresent()) {
            throw new NullPointerException();
        }
        BufferedImage rightPressed = ImgUtil.makeColorChanged(arrow.get(), COLOR_ARROW_PRESSED);
        BufferedImage rightRollover = ImgUtil.makeColorChanged(arrow.get(), COLOR_ARROW_ROLLOVER);
        BufferedImage rightEnabled = ImgUtil.makeColorChanged(arrow.get(), COLOR_ARROW_ENABLED);
        BufferedImage rightDisabled = ImgUtil.makeColorChanged(arrow.get(), COLOR_ARROW_DISABLED);
        ICON_RIGHT_PRESSED = ImgUtil.getImg(rightPressed);
        ICON_RIGHT_ENABLED = ImgUtil.getImg(rightEnabled);
        ICON_RIGHT_DISABLED = ImgUtil.getImg(rightDisabled);
        ICON_LEFT_PRESSED = ImgUtil.getImg(ImgUtil.makeFlipped(rightPressed));
        ICON_LEFT_ENABLED = ImgUtil.getImg(ImgUtil.makeFlipped(rightEnabled));
        ICON_LEFT_DISABLED = ImgUtil.getImg(ImgUtil.makeFlipped(rightDisabled));
        Optional<BufferedImage> circle = ImgUtil.getAppBuffered("circle_35");
        if (!circle.isPresent()) {
            throw new NullPointerException();
        }
        BufferedImage background = ImgUtil.makeColorChanged(circle.get(), MCon.colorFrame().darker());
        ICON_RIGHT_ROLLOVER = ImgUtil.getImg(ImgUtil.makeCombined(true, background, rightRollover));
        ICON_LEFT_ROLLOVER = ImgUtil.getImg(ImgUtil.makeCombined(true, background, ImgUtil.makeFlipped(rightRollover)));
        Optional<BufferedImage> minimal = ImgUtil.getAppBuffered("res_minimal");
        if (!minimal.isPresent()) {
            throw new NullPointerException();
        }
        BufferedImage minimalPressed = ImgUtil.makeColorChanged(minimal.get(), MCon.colorAccent());
        BufferedImage minimalRollover = ImgUtil.makeColorChanged(minimal.get(), COLOR_ARROW_ROLLOVER);
        BufferedImage minimalEnabled = ImgUtil.makeColorChanged(minimal.get(), COLOR_ARROW_ENABLED);
        BufferedImage minimalDisabled = ImgUtil.makeColorChanged(minimal.get(), COLOR_ARROW_DISABLED);
        ICON_MINIMAL_PRESSED = ImgUtil.getImg(minimalPressed);
        ICON_MINIMAL_ENABLED = ImgUtil.getImg(minimalEnabled);
        ICON_MINIMAL_DISABLED = ImgUtil.getImg(minimalDisabled);
        Optional<BufferedImage> detail = ImgUtil.getAppBuffered("res_detail");
        if (!detail.isPresent()) {
            throw new NullPointerException();
        }
        BufferedImage detailPressed = ImgUtil.makeColorChanged(detail.get(), MCon.colorAccent());
        BufferedImage detailRollover = ImgUtil.makeColorChanged(detail.get(), COLOR_ARROW_ROLLOVER);
        BufferedImage detailEnabled = ImgUtil.makeColorChanged(detail.get(), COLOR_ARROW_ENABLED);
        BufferedImage detailDisabled = ImgUtil.makeColorChanged(detail.get(), COLOR_ARROW_DISABLED);
        ICON_DETAILED_PRESSED = ImgUtil.getImg(detailPressed);
        ICON_DETAILED_ENABLED = ImgUtil.getImg(detailEnabled);
        ICON_DETAILED_DISABLED = ImgUtil.getImg(detailDisabled);
        Optional<BufferedImage> circle2 = ImgUtil.getAppBuffered("circle");
        if (!circle2.isPresent()) {
            throw new NullPointerException();
        }
        BufferedImage background2 = ImgUtil.makeColorChanged(circle2.get(), MCon.colorFrame().darker());
        ICON_MINIMAL_ROLLOVER = ImgUtil.getImg(ImgUtil.makeCombined(true, background2, minimalRollover));
        ICON_DETAILED_ROLLOVER = ImgUtil.getImg(ImgUtil.makeCombined(true, background2, detailRollover));
    }

    public static enum LabelAlign {
        LEFT("][p,||<>p<>"),
        BOTTOM("||<>p<>,[]<8>p");

        private final String mPos;

        private LabelAlign(String pPos) {
            this.mPos = pPos;
        }
    }
}

