/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BlockFault {
    private static final String LINE_SEP = System.getProperty("line.separator");
    @NotNull
    private Set<Integer> mFaults = new HashSet<Integer>();

    @NotNull
    public String print(@NotNull String pHeader) {
        StringBuilder sb = new StringBuilder(pHeader).append(LINE_SEP);
        for (Integer fault : this.mFaults) {
            sb.append(BlockFault.getBlockId(fault)).append('\t').append(BlockFault.getMeta(fault)).append(LINE_SEP);
        }
        this.mFaults = new HashSet<Integer>();
        return sb.toString();
    }

    public void add(byte pPureId, int pMeta) {
        this.mFaults.add(BlockFault.toFault(pPureId, pMeta));
    }

    public boolean isEmpty() {
        return this.mFaults.isEmpty();
    }

    public static int toFault(byte pPureId, int pMeta) {
        return (short)(pPureId & 0xFF) | pMeta << 8;
    }

    public static int getBlockId(int pFault) {
        return pFault & 0xFF;
    }

    public static int getMeta(int pFault) {
        return pFault >> 8 & 0xFF;
    }
}

