/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.area;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.world.area.IAreaServer;
import de.maggicraft.ism.world.area.IAreaWrapper;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AreaWrapper
implements IAreaWrapper {
    private IAreaServer mArea;

    @Override
    public void initialize() {
        try {
            ISMContainer.getMCLoaderServer().requiredAreaServer();
            this.mArea = (IAreaServer)ISMContainer.getRegistry().lookup("area");
        }
        catch (NotBoundException | RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    public void updateArea(@NotNull IPos pPosGreen, @NotNull IPos pPosRed) {
        try {
            this.mArea.updateArea(pPosGreen, pPosRed);
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    public void cancel() {
        try {
            this.mArea.cancel();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    @Nullable
    public IPos getPosGreen() {
        try {
            return this.mArea.getPosGreen();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalArgumentException();
        }
    }

    @Override
    @Nullable
    public IPos getPosRed() {
        try {
            return this.mArea.getPosRed();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalArgumentException();
        }
    }

    @Override
    @NotNull
    public IDim getDim() {
        try {
            return this.mArea.getDim();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalArgumentException();
        }
    }
}

