/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.boundingbox;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.world.boundingbox.EBoundingBoxState;
import de.maggicraft.ism.world.boundingbox.IBoundingBoxServer;
import de.maggicraft.ism.world.boundingbox.IBoundingBoxWrapper;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mcommons.state_machine.IState;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;

public class BoundingBoxWrapper
implements IBoundingBoxWrapper {
    private IBoundingBoxServer mBoundingBox;

    @Override
    public void initialize() {
        try {
            ISMContainer.getMCLoaderServer().requiredBoundingBoxServer();
            this.mBoundingBox = (IBoundingBoxServer)ISMContainer.getRegistry().lookup("boundingBox");
        }
        catch (NotBoundException | RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    public void place(@NotNull IPos pCorner, @NotNull IDim pDim) throws IllegalStateException {
        try {
            this.mBoundingBox.place(pCorner, pDim);
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    public void remove() throws IllegalStateException {
        try {
            this.mBoundingBox.remove();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    @NotNull
    public IState getState() {
        try {
            return this.mBoundingBox.isPlaced() ? EBoundingBoxState.PLACED : EBoundingBoxState.PLACED;
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalArgumentException();
        }
    }
}

