/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.info;

import de.maggicraft.ism.world.info.IWorldInfo;
import de.maggicraft.ism.world.info.IWorldInfoManager;
import de.maggicraft.ism.world.info.WorldInfo;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.ism.world.util.Pos;
import java.io.File;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldInfoManager
implements IWorldInfoManager {
    @Nullable
    private PlayerEntity mPlayer;
    @Nullable
    private IWorldInfo mWorldInfo;
    private boolean mIsLoggedIn;

    private static int toRot(int pDir) {
        return (pDir + 1) % 4;
    }

    @Override
    @NotNull
    public IWorldInfo getWorldInfo() throws IllegalStateException {
        if (this.mWorldInfo == null) {
            throw new IllegalStateException();
        }
        return this.mWorldInfo;
    }

    @Override
    @NotNull
    public IPos getPlayerPos() throws IllegalStateException {
        if (this.mPlayer == null) {
            throw new IllegalStateException();
        }
        int posX = (int)Math.round(this.mPlayer.func_226277_ct_() - 0.5);
        int posY = (int)Math.round(this.mPlayer.func_226278_cu_() - 0.5);
        int posZ = (int)Math.round(this.mPlayer.func_226281_cx_() - 0.5);
        return new Pos(posX, posY, posZ);
    }

    @Override
    public int getDir() throws IllegalStateException {
        if (this.mPlayer == null) {
            throw new IllegalStateException();
        }
        double val = (double)this.mPlayer.field_70177_z * 4.0 / 360.0 + 0.5;
        return MathHelper.func_76128_c((double)val) & 3;
    }

    @Override
    public int getRot() throws IllegalStateException {
        return WorldInfoManager.toRot(this.getDir());
    }

    @Override
    public boolean isLoggedIn() {
        return this.mIsLoggedIn;
    }

    @Override
    public boolean isLoggedOut() {
        return !this.mIsLoggedIn;
    }

    public void setWorld(@Nullable World pWorld) {
        this.mWorldInfo = pWorld == null ? null : new WorldInfo(new File(""), 42L);
    }

    public void setPlayer(@Nullable PlayerEntity pPlayer) {
        this.mPlayer = pPlayer;
    }

    public void setIsLoggedIn(boolean pIsLoggedIn) {
        this.mIsLoggedIn = pIsLoggedIn;
    }
}

