/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.info;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.world.info.IWorldInfo;
import de.maggicraft.ism.world.info.IWorldInfoManagerServer;
import de.maggicraft.ism.world.info.IWorldInfoManagerWrapper;
import de.maggicraft.ism.world.util.IPos;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;

public class WorldInfoManagerWrapper
implements IWorldInfoManagerWrapper {
    private IWorldInfoManagerServer mWorldInfoManager;

    @Override
    public void initialize() {
        try {
            ISMContainer.getMCLoaderServer().requiredWorldInfoManagerServer();
            this.mWorldInfoManager = (IWorldInfoManagerServer)ISMContainer.getRegistry().lookup("worldInfoManager");
        }
        catch (NotBoundException | RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    @NotNull
    public IWorldInfo getWorldInfo() throws IllegalStateException {
        try {
            return this.mWorldInfoManager.getWorldInfo();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalStateException();
        }
    }

    @Override
    @NotNull
    public IPos getPlayerPos() throws IllegalStateException {
        try {
            return this.mWorldInfoManager.getPlayerPos();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalStateException();
        }
    }

    @Override
    @Deprecated
    public int getDir() throws IllegalStateException {
        try {
            return this.mWorldInfoManager.getDir();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalStateException();
        }
    }

    @Override
    @Deprecated
    public int getRot() throws IllegalStateException {
        try {
            return this.mWorldInfoManager.getRot();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean isLoggedIn() {
        try {
            return this.mWorldInfoManager.isLoggedIn();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean isLoggedOut() {
        try {
            return this.mWorldInfoManager.isLoggedOut();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            throw new IllegalStateException();
        }
    }
}

