/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.logged;

import de.maggicraft.ism.loader.ItemManager;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.loader.MItems;
import de.maggicraft.ism.world.boundingbox.EBoundingBoxState;
import de.maggicraft.ism.world.info.WorldInfoManager;
import de.maggicraft.ism.world.logged.ELoggedType;
import de.maggicraft.ism.world.logged.ILoggedEvent;
import de.maggicraft.ism.world.logged.ILoggedManagerMC;
import de.maggicraft.ism.world.logged.LoggedInObservable;
import de.maggicraft.ism.world.logged.LoggedOutObservable;
import de.maggicraft.ism.world.util.MinecraftUtil;
import de.maggicraft.ism.world.util.WorldStateUtil;
import de.maggicraft.mcommons.event.IObserver;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;

public class LoggedManagerMC
implements ILoggedManagerMC {
    private final Map<ELoggedType, Collection<IObserver<ILoggedEvent>>> mObservers = new EnumMap<ELoggedType, Collection<IObserver<ILoggedEvent>>>(ELoggedType.class);

    @Override
    public void initialize() {
        MinecraftForge.EVENT_BUS.register((Object)new LoggedInObservable());
        MinecraftForge.EVENT_BUS.register((Object)new LoggedOutObservable());
        this.registerLoadWorld();
        this.registerUnloadWorld();
        this.registerISMEvents();
        this.registerItemDrop();
    }

    private void registerISMEvents() {
        this.registerObserver(ELoggedType.LOGGED_IN, pEvent -> {
            WorldInfoManager worldInfoManager = (WorldInfoManager)MCContainer.getWorldInfoManager();
            worldInfoManager.setWorld(pEvent.getWorld());
            worldInfoManager.setPlayer(pEvent.getPlayer());
            worldInfoManager.setIsLoggedIn(true);
            MCContainer.getLoggedManager().loggedIn();
        });
        this.registerObserver(ELoggedType.LOGGED_OUT, pEvent -> {
            WorldInfoManager worldInfoManager = (WorldInfoManager)MCContainer.getWorldInfoManager();
            worldInfoManager.setIsLoggedIn(false);
            MCContainer.getLoggedManager().loggedOut();
            worldInfoManager.setWorld(null);
            worldInfoManager.setPlayer(null);
        });
    }

    private void registerItemDrop() {
        this.registerObserver(ELoggedType.LOGGED_IN, pEvent -> {
            String dropExplorer;
            Optional<Item> itemExplorer = ItemManager.getItem(MItems.ITEM_EXPLORER);
            if (itemExplorer.isPresent() && ((dropExplorer = MCContainer.getSettings().dropExplorerMode()).equals("anyGM") || dropExplorer.equals("creative") && pEvent.getPlayer().func_184812_l_())) {
                boolean excludeWiki = true;
                String explorerName = itemExplorer.get().func_77658_a();
                PlayerInventory inventory = pEvent.getPlayer().field_71071_by;
                for (int i = 0; i < inventory.func_70302_i_() && excludeWiki; ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (!stack.func_77973_b().func_77658_a().equals(explorerName)) continue;
                    excludeWiki = false;
                }
                if (excludeWiki) {
                    MinecraftUtil.dropItem(itemExplorer.get());
                }
            }
        });
    }

    private void registerLoadWorld() {
        this.registerObserver(ELoggedType.LOGGED_IN, pEvent -> {
            MinecraftUtil.setPlayer(pEvent.getPlayer());
            WorldStateUtil.setWorld(pEvent.getWorld());
        });
    }

    private void registerUnloadWorld() {
        this.registerObserver(ELoggedType.LOGGED_OUT, pEvent -> {
            MCContainer.getArea().removeBox();
            MCContainer.getArea().removeBlocks();
            if (MCContainer.getBoundingBox().getState() == EBoundingBoxState.PLACED) {
                MCContainer.getBoundingBox().remove();
            }
            MinecraftUtil.setPlayer(null);
            WorldStateUtil.setWorld(null);
        });
    }

    @Override
    @NotNull
    public Map<ELoggedType, Collection<IObserver<ILoggedEvent>>> getObservers() {
        return this.mObservers;
    }
}

