/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.INBTBase;
import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.MTagCompound;
import de.maggicraft.ism.world.nbt.MTagEnd;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.Nullable;

public class CompressedStreamTools {
    public static MTagCompound readCompressed(InputStream pInput) throws IOException {
        MTagCompound compound;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(pInput)));){
            compound = CompressedStreamTools.read(datainputstream, MSizeTracker.INFINITE);
        }
        return compound;
    }

    public static void writeCompressed(MTagCompound pCompound, OutputStream pOutputStream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(pOutputStream)));){
            CompressedStreamTools.write(pCompound, dataoutputstream);
        }
    }

    public static void safeWrite(MTagCompound pCompound, File pFileIn) throws IOException {
        File file1 = new File(pFileIn.getAbsolutePath() + "_tmp");
        if (file1.exists()) {
            file1.delete();
        }
        CompressedStreamTools.write(pCompound, file1);
        if (pFileIn.exists()) {
            pFileIn.delete();
        }
        if (pFileIn.exists()) {
            throw new IOException("Failed to delete " + pFileIn);
        }
        file1.renameTo(pFileIn);
    }

    public static void write(MTagCompound pCompound, File pFileIn) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(pFileIn));){
            CompressedStreamTools.write(pCompound, dataoutputstream);
        }
    }

    @Nullable
    public static MTagCompound read(File pFileIn) throws IOException {
        if (pFileIn.exists()) {
            MTagCompound compound;
            try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(pFileIn));){
                compound = CompressedStreamTools.read(datainputstream, MSizeTracker.INFINITE);
            }
            return compound;
        }
        return null;
    }

    public static MTagCompound read(DataInputStream pInputStream) throws IOException {
        return CompressedStreamTools.read(pInputStream, MSizeTracker.INFINITE);
    }

    public static MTagCompound read(DataInput pInput, MSizeTracker pSizeTracker) throws IOException {
        INBTBase inbtbase = CompressedStreamTools.read(pInput, 0, pSizeTracker);
        if (inbtbase instanceof MTagCompound) {
            return (MTagCompound)inbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(MTagCompound pCompound, DataOutput pOutput) throws IOException {
        CompressedStreamTools.writeTag(pCompound, pOutput);
    }

    private static void writeTag(INBTBase pTag, DataOutput pOutput) throws IOException {
        pOutput.writeByte(pTag.getId());
        if (pTag.getId() != 0) {
            pOutput.writeUTF("");
            pTag.write(pOutput);
        }
    }

    private static INBTBase read(DataInput pInput, int pDepth, MSizeTracker pSizeTracker) throws IOException {
        byte b0 = pInput.readByte();
        pSizeTracker.read(8L);
        if (b0 == 0) {
            return new MTagEnd();
        }
        MSizeTracker.readUTF(pSizeTracker, pInput.readUTF());
        pSizeTracker.read(32L);
        INBTBase inbtbase = INBTBase.create(b0);
        try {
            inbtbase.read(pInput, pDepth, pSizeTracker);
            return inbtbase;
        }
        catch (IOException pE) {
            String message = "Loading NBT data, NBT Tag, Tag type: " + b0;
            throw new IOException(message, pE);
        }
    }
}

