/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.MTagByte;
import de.maggicraft.ism.world.nbt.MTagByteArray;
import de.maggicraft.ism.world.nbt.MTagCompound;
import de.maggicraft.ism.world.nbt.MTagDouble;
import de.maggicraft.ism.world.nbt.MTagEnd;
import de.maggicraft.ism.world.nbt.MTagFloat;
import de.maggicraft.ism.world.nbt.MTagInt;
import de.maggicraft.ism.world.nbt.MTagIntArray;
import de.maggicraft.ism.world.nbt.MTagList;
import de.maggicraft.ism.world.nbt.MTagLong;
import de.maggicraft.ism.world.nbt.MTagLongArray;
import de.maggicraft.ism.world.nbt.MTagShort;
import de.maggicraft.ism.world.nbt.MTagString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public interface INBTBase {
    public static final String[] NBT_TYPES = new String[]{"END", "BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "BYTE[]", "STRING", "LIST", "COMPOUND", "INT[]", "LONG[]"};

    @NotNull
    public static INBTBase create(byte pId) {
        switch (pId) {
            case 0: {
                return new MTagEnd();
            }
            case 1: {
                return new MTagByte();
            }
            case 2: {
                return new MTagShort();
            }
            case 3: {
                return new MTagInt();
            }
            case 4: {
                return new MTagLong();
            }
            case 5: {
                return new MTagFloat();
            }
            case 6: {
                return new MTagDouble();
            }
            case 7: {
                return new MTagByteArray();
            }
            case 8: {
                return new MTagString();
            }
            case 9: {
                return new MTagList();
            }
            case 10: {
                return new MTagCompound();
            }
            case 11: {
                return new MTagIntArray();
            }
            case 12: {
                return new MTagLongArray();
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    public static String getTypeName(int pId) {
        switch (pId) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
            case 11: {
                return "TAG_Int_Array";
            }
            case 12: {
                return "TAG_Long_Array";
            }
            case 99: {
                return "Any Numeric Tag";
            }
        }
        return "UNKNOWN";
    }

    public void write(@NotNull DataOutput var1) throws IOException;

    public void read(@NotNull DataInput var1, int var2, @NotNull MSizeTracker var3) throws IOException;

    @NotNull
    public String toString();

    @NotNull
    public INBTBase copy();

    @NotNull
    default public String getString() {
        return this.toString();
    }

    public byte getId();
}

