/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import org.jetbrains.annotations.NotNull;

public class MSizeTracker {
    public static final MSizeTracker INFINITE = new MSizeTracker(0L){

        @Override
        public void read(long bits) {
        }
    };
    private final long mMax;
    private long mRead;

    public MSizeTracker(long pMax) {
        this.mMax = pMax;
    }

    public static void readUTF(@NotNull MSizeTracker tracker, String data) {
        tracker.read(16L);
        if (data != null) {
            int len = data.length();
            int utflen = 0;
            for (int i = 0; i < len; ++i) {
                char c = data.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            tracker.read(8 * utflen);
        }
    }

    public void read(long bits) {
        this.mRead += bits / 8L;
        if (this.mRead > this.mMax) {
            throw new RuntimeException("Tried to read NBT tag that was too big; tried to allocate: " + this.mRead + "bytes where max allowed: " + this.mMax);
        }
    }
}

