/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.INBTBase;
import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.MTagByte;
import de.maggicraft.ism.world.nbt.NBTPrimitive;
import de.maggicraft.ism.world.nbt.NBTTagCollection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MTagByteArray
extends NBTTagCollection<MTagByte> {
    private byte[] mData;

    MTagByteArray() {
    }

    public MTagByteArray(byte[] pData) {
        this.mData = pData;
    }

    public MTagByteArray(@NotNull List<Byte> pList) {
        this(MTagByteArray.toArray(pList));
    }

    private static byte[] toArray(@NotNull List<Byte> pList) {
        byte[] bytes = new byte[pList.size()];
        for (int i = 0; i < pList.size(); ++i) {
            Byte obyte = pList.get(i);
            bytes[i] = obyte == null ? (byte)0 : obyte;
        }
        return bytes;
    }

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        pOutput.writeInt(this.mData.length);
        pOutput.write(this.mData);
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        pSizeTracker.read(192L);
        int i = pInput.readInt();
        pSizeTracker.read(8 * i);
        this.mData = new byte[i];
        pInput.readFully(this.mData);
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[B;");
        for (int i = 0; i < this.mData.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.mData[i]).append('B');
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    @NotNull
    public INBTBase copy() {
        byte[] abyte = new byte[this.mData.length];
        System.arraycopy(this.mData, 0, abyte, 0, this.mData.length);
        return new MTagByteArray(abyte);
    }

    @Override
    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagByteArray && Arrays.equals(this.mData, ((MTagByteArray)pObject).mData);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mData);
    }

    public byte[] getByteArray() {
        return this.mData;
    }

    @Override
    public int size() {
        return this.mData.length;
    }

    @Override
    @NotNull
    public MTagByte getTag(int pIndex) {
        return new MTagByte(this.mData[pIndex]);
    }

    @Override
    public void setTag(int pIndex, @NotNull INBTBase pNBTBase) {
        this.mData[pIndex] = ((NBTPrimitive)pNBTBase).getByte();
    }
}

