/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.INBTBase;
import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.MTagByte;
import de.maggicraft.ism.world.nbt.MTagByteArray;
import de.maggicraft.ism.world.nbt.MTagDouble;
import de.maggicraft.ism.world.nbt.MTagFloat;
import de.maggicraft.ism.world.nbt.MTagInt;
import de.maggicraft.ism.world.nbt.MTagIntArray;
import de.maggicraft.ism.world.nbt.MTagList;
import de.maggicraft.ism.world.nbt.MTagLong;
import de.maggicraft.ism.world.nbt.MTagLongArray;
import de.maggicraft.ism.world.nbt.MTagShort;
import de.maggicraft.ism.world.nbt.MTagString;
import de.maggicraft.ism.world.nbt.NBTPrimitive;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MTagCompound
implements INBTBase {
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private final Map<String, INBTBase> mTagMap = new HashMap<String, INBTBase>();

    private static void writeEntry(String name, INBTBase data, DataOutput output) throws IOException {
        output.writeByte(data.getId());
        if (data.getId() != 0) {
            output.writeUTF(name);
            data.write(output);
        }
    }

    private static byte readType(DataInput input, MSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(8L);
        return input.readByte();
    }

    private static String readKey(DataInput input, MSizeTracker sizeTracker) throws IOException {
        return input.readUTF();
    }

    private static INBTBase readNBT(byte id, String key, DataInput input, int depth, MSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(32L);
        INBTBase inbtbase = INBTBase.create(id);
        try {
            inbtbase.read(input, depth, sizeTracker);
            return inbtbase;
        }
        catch (IOException var9) {
            String message = "Loading NBT data, NBT Tag, Tag name: " + key + ", Tag type: " + id;
            throw new IOException(message, var9);
        }
    }

    protected static String handleEscape(String p_193582_0_) {
        return SIMPLE_VALUE.matcher(p_193582_0_).matches() ? p_193582_0_ : MTagString.quoteAndEscape(p_193582_0_, true);
    }

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        for (Map.Entry<String, INBTBase> entry : this.mTagMap.entrySet()) {
            INBTBase inbtbase = entry.getValue();
            MTagCompound.writeEntry(entry.getKey(), inbtbase, pOutput);
        }
        pOutput.writeByte(0);
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        byte b0;
        pSizeTracker.read(384L);
        if (pDepth > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.mTagMap.clear();
        while ((b0 = MTagCompound.readType(pInput, pSizeTracker)) != 0) {
            String s = MTagCompound.readKey(pInput, pSizeTracker);
            pSizeTracker.read(224 + 16 * s.length());
            INBTBase inbtbase = MTagCompound.readNBT(b0, s, pInput, pDepth + 1, pSizeTracker);
            if (this.mTagMap.put(s, inbtbase) == null) continue;
            pSizeTracker.read(288L);
        }
    }

    public Set<String> keySet() {
        return this.mTagMap.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public int size() {
        return this.mTagMap.size();
    }

    public void setTag(String key, INBTBase value) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid null NBT value with key " + key);
        }
        this.mTagMap.put(key, value);
    }

    public void setByte(String key, byte value) {
        this.mTagMap.put(key, new MTagByte(value));
    }

    public void setShort(String key, short value) {
        this.mTagMap.put(key, new MTagShort(value));
    }

    public void setInt(String key, int value) {
        this.mTagMap.put(key, new MTagInt(value));
    }

    public void setLong(String key, long value) {
        this.mTagMap.put(key, new MTagLong(value));
    }

    public void setUniqueId(String key, UUID value) {
        this.setLong(key + "Most", value.getMostSignificantBits());
        this.setLong(key + "Least", value.getLeastSignificantBits());
    }

    @Nullable
    public UUID getUniqueId(String key) {
        return new UUID(this.getLong(key + "Most"), this.getLong(key + "Least"));
    }

    public boolean hasUniqueId(String key) {
        return this.contains(key + "Most", 99) && this.contains(key + "Least", 99);
    }

    public void setFloat(String key, float value) {
        this.mTagMap.put(key, new MTagFloat(value));
    }

    public void setDouble(String key, double value) {
        this.mTagMap.put(key, new MTagDouble(value));
    }

    public void setString(String key, String value) {
        this.mTagMap.put(key, new MTagString(value));
    }

    public void setByteArray(String key, byte[] value) {
        this.mTagMap.put(key, new MTagByteArray(value));
    }

    public void setIntArray(String key, int[] value) {
        this.mTagMap.put(key, new MTagIntArray(value));
    }

    public void setIntArray(String pKey, List<Integer> p_197646_2_) {
        this.mTagMap.put(pKey, new MTagIntArray(p_197646_2_));
    }

    public void setLongArray(String pKey, long[] p_197644_2_) {
        this.mTagMap.put(pKey, new MTagLongArray(p_197644_2_));
    }

    public void setLongArray(String pKey, List<Long> p_202168_2_) {
        this.mTagMap.put(pKey, new MTagLongArray(p_202168_2_));
    }

    public void setBoolean(String key, boolean value) {
        this.setByte(key, (byte)(value ? 1 : 0));
    }

    public INBTBase getTag(String key) {
        return this.mTagMap.get(key);
    }

    public byte getTagId(String key) {
        INBTBase inbtbase = this.mTagMap.get(key);
        return inbtbase == null ? (byte)0 : inbtbase.getId();
    }

    public boolean hasKey(String key) {
        return this.mTagMap.containsKey(key);
    }

    public boolean contains(String key, int type) {
        byte i = this.getTagId(key);
        if (i == type) {
            return true;
        }
        if (type != 99) {
            return false;
        }
        return i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6;
    }

    public byte getByte(String key) {
        try {
            if (this.contains(key, 99)) {
                return ((NBTPrimitive)this.mTagMap.get(key)).getByte();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short getShort(String key) {
        try {
            if (this.contains(key, 99)) {
                return ((NBTPrimitive)this.mTagMap.get(key)).getShort();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int getInt(String key) {
        try {
            if (this.contains(key, 99)) {
                return ((NBTPrimitive)this.mTagMap.get(key)).getInt();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long getLong(String key) {
        try {
            if (this.contains(key, 99)) {
                return ((NBTPrimitive)this.mTagMap.get(key)).getLong();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float getFloat(String key) {
        try {
            if (this.contains(key, 99)) {
                return ((NBTPrimitive)this.mTagMap.get(key)).getFloat();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double getDouble(String key) {
        try {
            if (this.contains(key, 99)) {
                return ((NBTPrimitive)this.mTagMap.get(key)).getDouble();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String getString(String key) {
        try {
            if (this.contains(key, 8)) {
                return this.mTagMap.get(key).getString();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] getByteArray(String pKey) {
        try {
            if (this.contains(pKey, 7)) {
                return ((MTagByteArray)this.mTagMap.get(pKey)).getByteArray();
            }
        }
        catch (ClassCastException pE) {
            throw this.createMessage(pKey, 7, pE);
        }
        return new byte[0];
    }

    public int[] getIntArray(String pKey) {
        try {
            if (this.contains(pKey, 11)) {
                return ((MTagIntArray)this.mTagMap.get(pKey)).getIntArray();
            }
        }
        catch (ClassCastException pE) {
            pE.printStackTrace();
            throw this.createMessage(pKey, 11, pE);
        }
        return new int[0];
    }

    public long[] getLongArray(String pKey) {
        try {
            if (this.contains(pKey, 12)) {
                return ((MTagLongArray)this.mTagMap.get(pKey)).getAsLongArray();
            }
        }
        catch (ClassCastException pE) {
            throw this.createMessage(pKey, 12, pE);
        }
        return new long[0];
    }

    private IllegalArgumentException createMessage(String pKey, int pExpectedType, ClassCastException pE) {
        String tagType = NBT_TYPES[this.mTagMap.get(pKey).getId()];
        String message = "Reading NBT data, Corrupt NBT tag, Tag type found: " + tagType + ", tag type expected: " + NBT_TYPES[pExpectedType] + ", tag name: " + pKey;
        return new IllegalArgumentException(message, pE);
    }

    public MTagCompound getCompound(String pKey) {
        try {
            if (this.contains(pKey, 10)) {
                return (MTagCompound)this.mTagMap.get(pKey);
            }
        }
        catch (ClassCastException pE) {
            throw this.createMessage(pKey, 10, pE);
        }
        return new MTagCompound();
    }

    public MTagList getList(String pKey, int pType) {
        try {
            if (this.getTagId(pKey) == 9) {
                MTagList list = (MTagList)this.mTagMap.get(pKey);
                if (!list.isEmpty() && list.getTagType() != pType) {
                    return new MTagList();
                }
                return list;
            }
        }
        catch (ClassCastException pE) {
            throw this.createMessage(pKey, 9, pE);
        }
        return new MTagList();
    }

    public boolean getBoolean(String key) {
        return this.getByte(key) != 0;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("{");
        Set<String> collection = this.mTagMap.keySet();
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(MTagCompound.handleEscape(s)).append(':').append(this.mTagMap.get(s));
        }
        return stringbuilder.append('}').toString();
    }

    public boolean isEmpty() {
        return this.mTagMap.isEmpty();
    }

    @Override
    @NotNull
    public MTagCompound copy() {
        MTagCompound compound = new MTagCompound();
        for (Map.Entry<String, INBTBase> entry : this.mTagMap.entrySet()) {
            compound.setTag(entry.getKey(), entry.getValue().copy());
        }
        return compound;
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagCompound && Objects.equals(this.mTagMap, ((MTagCompound)pObject).mTagMap);
    }

    public int hashCode() {
        return this.mTagMap.hashCode();
    }

    public MTagCompound merge(MTagCompound other) {
        for (Map.Entry<String, INBTBase> entry : other.mTagMap.entrySet()) {
            String s = entry.getKey();
            INBTBase inbtbase = entry.getValue();
            if (inbtbase.getId() == 10) {
                if (this.contains(s, 10)) {
                    MTagCompound compound = this.getCompound(s);
                    compound.merge((MTagCompound)inbtbase);
                    continue;
                }
                this.setTag(s, inbtbase.copy());
                continue;
            }
            this.setTag(s, inbtbase.copy());
        }
        return this;
    }
}

