/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.NBTPrimitive;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class MTagDouble
extends NBTPrimitive {
    private double mData;

    MTagDouble() {
    }

    public MTagDouble(double pData) {
        this.mData = pData;
    }

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        pOutput.writeDouble(this.mData);
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        pSizeTracker.read(128L);
        this.mData = pInput.readDouble();
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    @NotNull
    public String toString() {
        return this.mData + "d";
    }

    @Override
    @NotNull
    public MTagDouble copy() {
        return new MTagDouble(this.mData);
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagDouble && this.mData == ((MTagDouble)pObject).mData;
    }

    public int hashCode() {
        long i = Double.doubleToLongBits(this.mData);
        return (int)(i ^ i >>> 32);
    }

    @Override
    public long getLong() {
        return (long)Math.floor(this.mData);
    }

    @Override
    public int getInt() {
        return (int)Math.floor(this.mData);
    }

    @Override
    public short getShort() {
        return (short)((int)Math.floor(this.mData) & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)((int)Math.floor(this.mData) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.mData;
    }

    @Override
    public float getFloat() {
        return (float)this.mData;
    }

    @Override
    @NotNull
    public Number getAsNumber() {
        return this.mData;
    }
}

