/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.NBTPrimitive;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class MTagFloat
extends NBTPrimitive {
    private float mData;

    MTagFloat() {
    }

    public MTagFloat(float pData) {
        this.mData = pData;
    }

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        pOutput.writeFloat(this.mData);
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        pSizeTracker.read(96L);
        this.mData = pInput.readFloat();
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    @NotNull
    public String toString() {
        return this.mData + "f";
    }

    @Override
    @NotNull
    public MTagFloat copy() {
        return new MTagFloat(this.mData);
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagFloat && this.mData == ((MTagFloat)pObject).mData;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.mData);
    }

    @Override
    public long getLong() {
        return (long)this.mData;
    }

    @Override
    public int getInt() {
        return (int)Math.floor(this.mData);
    }

    @Override
    public short getShort() {
        return (short)((int)Math.floor(this.mData) & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)((int)Math.floor(this.mData) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.mData;
    }

    @Override
    public float getFloat() {
        return this.mData;
    }

    @Override
    @NotNull
    public Number getAsNumber() {
        return Float.valueOf(this.mData);
    }
}

