/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.INBTBase;
import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.MTagInt;
import de.maggicraft.ism.world.nbt.NBTPrimitive;
import de.maggicraft.ism.world.nbt.NBTTagCollection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MTagIntArray
extends NBTTagCollection<MTagInt> {
    private int[] mIntArray;

    MTagIntArray() {
    }

    public MTagIntArray(int[] pInts) {
        this.mIntArray = pInts;
    }

    public MTagIntArray(@NotNull List<Integer> pList) {
        this(MTagIntArray.toArray(pList));
    }

    private static int[] toArray(@NotNull List<Integer> pList) {
        int[] aint = new int[pList.size()];
        for (int i = 0; i < pList.size(); ++i) {
            Integer integer = pList.get(i);
            aint[i] = integer == null ? 0 : integer;
        }
        return aint;
    }

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        int[] var2;
        pOutput.writeInt(this.mIntArray.length);
        for (int i : var2 = this.mIntArray) {
            pOutput.writeInt(i);
        }
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        pSizeTracker.read(192L);
        int i = pInput.readInt();
        pSizeTracker.read(32 * i);
        this.mIntArray = new int[i];
        for (int j = 0; j < i; ++j) {
            this.mIntArray[j] = pInput.readInt();
        }
    }

    @Override
    public byte getId() {
        return 11;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[I;");
        for (int i = 0; i < this.mIntArray.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.mIntArray[i]);
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    @NotNull
    public MTagIntArray copy() {
        int[] ints = new int[this.mIntArray.length];
        System.arraycopy(this.mIntArray, 0, ints, 0, this.mIntArray.length);
        return new MTagIntArray(ints);
    }

    @Override
    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagIntArray && Arrays.equals(this.mIntArray, ((MTagIntArray)pObject).mIntArray);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mIntArray);
    }

    public int[] getIntArray() {
        return this.mIntArray;
    }

    @Override
    public int size() {
        return this.mIntArray.length;
    }

    @Override
    @NotNull
    public MTagInt getTag(int pIndex) {
        return new MTagInt(this.mIntArray[pIndex]);
    }

    @Override
    public void setTag(int pIndex, @NotNull INBTBase pNBTBase) {
        this.mIntArray[pIndex] = ((NBTPrimitive)pNBTBase).getInt();
    }
}

