/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.INBTBase;
import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.MTagCompound;
import de.maggicraft.ism.world.nbt.MTagDouble;
import de.maggicraft.ism.world.nbt.MTagEnd;
import de.maggicraft.ism.world.nbt.MTagFloat;
import de.maggicraft.ism.world.nbt.MTagInt;
import de.maggicraft.ism.world.nbt.MTagIntArray;
import de.maggicraft.ism.world.nbt.MTagShort;
import de.maggicraft.ism.world.nbt.NBTTagCollection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MTagList
extends NBTTagCollection<INBTBase> {
    private List<INBTBase> mTagList = new ArrayList<INBTBase>();
    private byte mTagType = 0;

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        this.mTagType = this.mTagList.isEmpty() ? (byte)0 : this.mTagList.get(0).getId();
        pOutput.writeByte(this.mTagType);
        pOutput.writeInt(this.mTagList.size());
        for (INBTBase pINBTBase : this.mTagList) {
            pINBTBase.write(pOutput);
        }
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        pSizeTracker.read(296L);
        if (pDepth > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.mTagType = pInput.readByte();
        int i = pInput.readInt();
        if (this.mTagType == 0 && i > 0) {
            throw new RuntimeException("Missing type on ListTag");
        }
        pSizeTracker.read(32L * (long)i);
        this.mTagList = new ArrayList<INBTBase>(i);
        for (int j = 0; j < i; ++j) {
            INBTBase inbtbase = INBTBase.create(this.mTagType);
            inbtbase.read(pInput, pDepth + 1, pSizeTracker);
            this.mTagList.add(inbtbase);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[");
        for (int i = 0; i < this.mTagList.size(); ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.mTagList.get(i));
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    public boolean add(INBTBase p_add_1_) {
        if (p_add_1_.getId() == 0) {
            return false;
        }
        if (this.mTagType == 0) {
            this.mTagType = p_add_1_.getId();
        } else if (this.mTagType != p_add_1_.getId()) {
            return false;
        }
        this.mTagList.add(p_add_1_);
        return true;
    }

    @Override
    public INBTBase set(int pIndex, @NotNull INBTBase pNBTBase) {
        if (pNBTBase.getId() == 0) {
            return this.mTagList.get(pIndex);
        }
        if (pIndex >= 0 && pIndex < this.mTagList.size()) {
            if (this.mTagType == 0) {
                this.mTagType = pNBTBase.getId();
            } else if (this.mTagType != pNBTBase.getId()) {
                return this.mTagList.get(pIndex);
            }
            return this.mTagList.set(pIndex, pNBTBase);
        }
        return null;
    }

    @Override
    public INBTBase remove(int p_remove_1_) {
        return this.mTagList.remove(p_remove_1_);
    }

    @Override
    public boolean isEmpty() {
        return this.mTagList.isEmpty();
    }

    public MTagCompound getCompound(int i) {
        INBTBase inbtbase;
        if (i >= 0 && i < this.mTagList.size() && (inbtbase = this.mTagList.get(i)).getId() == 10) {
            return (MTagCompound)inbtbase;
        }
        return new MTagCompound();
    }

    public MTagList getList(int iIn) {
        INBTBase inbtbase;
        if (iIn >= 0 && iIn < this.mTagList.size() && (inbtbase = this.mTagList.get(iIn)).getId() == 9) {
            return (MTagList)inbtbase;
        }
        return new MTagList();
    }

    public short getShort(int iIn) {
        INBTBase inbtbase;
        if (iIn >= 0 && iIn < this.mTagList.size() && (inbtbase = this.mTagList.get(iIn)).getId() == 2) {
            return ((MTagShort)inbtbase).getShort();
        }
        return 0;
    }

    public int getInt(int iIn) {
        INBTBase inbtbase;
        if (iIn >= 0 && iIn < this.mTagList.size() && (inbtbase = this.mTagList.get(iIn)).getId() == 3) {
            return ((MTagInt)inbtbase).getInt();
        }
        return 0;
    }

    public int[] getIntArray(int i) {
        INBTBase inbtbase;
        if (i >= 0 && i < this.mTagList.size() && (inbtbase = this.mTagList.get(i)).getId() == 11) {
            return ((MTagIntArray)inbtbase).getIntArray();
        }
        return new int[0];
    }

    public double getDouble(int i) {
        INBTBase inbtbase;
        if (i >= 0 && i < this.mTagList.size() && (inbtbase = this.mTagList.get(i)).getId() == 6) {
            return ((MTagDouble)inbtbase).getDouble();
        }
        return 0.0;
    }

    public float getFloat(int i) {
        INBTBase inbtbase;
        if (i >= 0 && i < this.mTagList.size() && (inbtbase = this.mTagList.get(i)).getId() == 5) {
            return ((MTagFloat)inbtbase).getFloat();
        }
        return 0.0f;
    }

    public String getString(int i) {
        if (i >= 0 && i < this.mTagList.size()) {
            INBTBase inbtbase = this.mTagList.get(i);
            return inbtbase.getId() == 8 ? inbtbase.getString() : inbtbase.toString();
        }
        return "";
    }

    @Override
    @NotNull
    public INBTBase get(int pIndex) {
        return pIndex >= 0 && pIndex < this.mTagList.size() ? this.mTagList.get(pIndex) : new MTagEnd();
    }

    @Override
    public int size() {
        return this.mTagList.size();
    }

    @Override
    @NotNull
    public INBTBase getTag(int pIndex) {
        return this.mTagList.get(pIndex);
    }

    @Override
    public void setTag(int pIndex, @NotNull INBTBase pNBTBase) {
        this.mTagList.set(pIndex, pNBTBase);
    }

    public void removeTag(int p_197649_1_) {
        this.mTagList.remove(p_197649_1_);
    }

    @Override
    @NotNull
    public MTagList copy() {
        MTagList list = new MTagList();
        list.mTagType = this.mTagType;
        for (INBTBase inbtbase : this.mTagList) {
            list.mTagList.add(inbtbase.copy());
        }
        return list;
    }

    @Override
    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagList && Objects.equals(this.mTagList, ((MTagList)pObject).mTagList);
    }

    @Override
    public int hashCode() {
        return this.mTagList.hashCode();
    }

    public int getTagType() {
        return this.mTagType;
    }
}

