/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.NBTPrimitive;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class MTagLong
extends NBTPrimitive {
    private long mData;

    MTagLong() {
    }

    public MTagLong(long data) {
        this.mData = data;
    }

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        pOutput.writeLong(this.mData);
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        pSizeTracker.read(128L);
        this.mData = pInput.readLong();
    }

    @Override
    public byte getId() {
        return 4;
    }

    @Override
    @NotNull
    public String toString() {
        return this.mData + "L";
    }

    @Override
    @NotNull
    public MTagLong copy() {
        return new MTagLong(this.mData);
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagLong && this.mData == ((MTagLong)pObject).mData;
    }

    public int hashCode() {
        return (int)(this.mData ^ this.mData >>> 32);
    }

    @Override
    public long getLong() {
        return this.mData;
    }

    @Override
    public int getInt() {
        return (int)this.mData;
    }

    @Override
    public short getShort() {
        return (short)(this.mData & 0xFFFFL);
    }

    @Override
    public byte getByte() {
        return (byte)(this.mData & 0xFFL);
    }

    @Override
    public double getDouble() {
        return this.mData;
    }

    @Override
    public float getFloat() {
        return this.mData;
    }

    @Override
    @NotNull
    public Number getAsNumber() {
        return this.mData;
    }
}

