/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.INBTBase;
import de.maggicraft.ism.world.nbt.MSizeTracker;
import de.maggicraft.ism.world.nbt.MTagLong;
import de.maggicraft.ism.world.nbt.NBTPrimitive;
import de.maggicraft.ism.world.nbt.NBTTagCollection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MTagLongArray
extends NBTTagCollection<MTagLong> {
    private long[] mLongs;

    MTagLongArray() {
    }

    public MTagLongArray(long[] pLongs) {
        this.mLongs = pLongs;
    }

    public MTagLongArray(List<Long> pLongs) {
        this(MTagLongArray.toArray(pLongs));
    }

    private static long[] toArray(List<Long> pLongs) {
        long[] along = new long[pLongs.size()];
        for (int i = 0; i < pLongs.size(); ++i) {
            Long olong = pLongs.get(i);
            along[i] = olong == null ? 0L : olong;
        }
        return along;
    }

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        long[] var2;
        pOutput.writeInt(this.mLongs.length);
        for (long i : var2 = this.mLongs) {
            pOutput.writeLong(i);
        }
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        pSizeTracker.read(192L);
        int i = pInput.readInt();
        pSizeTracker.read(64 * i);
        this.mLongs = new long[i];
        for (int j = 0; j < i; ++j) {
            this.mLongs[j] = pInput.readLong();
        }
    }

    @Override
    public byte getId() {
        return 12;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[L;");
        for (int i = 0; i < this.mLongs.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.mLongs[i]).append('L');
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    @NotNull
    public MTagLongArray copy() {
        long[] along = new long[this.mLongs.length];
        System.arraycopy(this.mLongs, 0, along, 0, this.mLongs.length);
        return new MTagLongArray(along);
    }

    @Override
    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagLongArray && Arrays.equals(this.mLongs, ((MTagLongArray)pObject).mLongs);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mLongs);
    }

    public long[] getAsLongArray() {
        return this.mLongs;
    }

    @Override
    public int size() {
        return this.mLongs.length;
    }

    @Override
    @NotNull
    public MTagLong getTag(int pIndex) {
        return new MTagLong(this.mLongs[pIndex]);
    }

    @Override
    public void setTag(int pIndex, @NotNull INBTBase pNBTBase) {
        this.mLongs[pIndex] = ((NBTPrimitive)pNBTBase).getLong();
    }
}

