/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.world.nbt.INBTBase;
import de.maggicraft.ism.world.nbt.MSizeTracker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MTagString
implements INBTBase {
    private String mData;

    public MTagString() {
        this("");
    }

    public MTagString(String pData) {
        Objects.requireNonNull(pData, "Null string not allowed");
        this.mData = pData;
    }

    public static String quoteAndEscape(String p_197654_0_, boolean p_197654_1_) {
        StringBuilder stringbuilder = new StringBuilder();
        if (p_197654_1_) {
            stringbuilder.append('\"');
        }
        for (int i = 0; i < p_197654_0_.length(); ++i) {
            char c0 = p_197654_0_.charAt(i);
            if (c0 == '\\' || c0 == '\"') {
                stringbuilder.append('\\');
            }
            stringbuilder.append(c0);
        }
        if (p_197654_1_) {
            stringbuilder.append('\"');
        }
        return stringbuilder.toString();
    }

    @Override
    public void write(@NotNull DataOutput pOutput) throws IOException {
        pOutput.writeUTF(this.mData);
    }

    @Override
    public void read(@NotNull DataInput pInput, int pDepth, @NotNull MSizeTracker pSizeTracker) throws IOException {
        pSizeTracker.read(288L);
        this.mData = pInput.readUTF();
        MSizeTracker.readUTF(pSizeTracker, this.mData);
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    @NotNull
    public String toString() {
        return MTagString.quoteAndEscape(this.mData, true);
    }

    @Override
    @NotNull
    public MTagString copy() {
        return new MTagString(this.mData);
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        return pObject instanceof MTagString && Objects.equals(this.mData, ((MTagString)pObject).mData);
    }

    public int hashCode() {
        return this.mData.hashCode();
    }

    @Override
    @NotNull
    public String getString() {
        return this.mData;
    }
}

