/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.nbt;

import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.str.ReadableStructure;
import de.maggicraft.ism.world.nbt.CompressedStreamTools;
import de.maggicraft.ism.world.nbt.MTagCompound;
import de.maggicraft.ism.world.util.Dim;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IOffset;
import de.maggicraft.ism.world.util.Offset;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;

public final class SchematicUtil {
    public static final String SCHEMATIC_EXTENSION = ".schematic";

    private SchematicUtil() {
    }

    public static ReadableStructure toReadableStructure(@NotNull File pInput) throws StorageException {
        try {
            MTagCompound nbt = SchematicUtil.getNBT(pInput);
            int blocksQuantity = SchematicUtil.countBlocks(nbt.getByteArray("Blocks"));
            return new ReadableStructure(pInput, SchematicUtil.dimension(nbt), SchematicUtil.offset(nbt), blocksQuantity);
        }
        catch (IOException pE) {
            throw new StorageException(EStorageException.COMPOUND, "getNBT from file: " + pInput.getAbsolutePath(), pE);
        }
    }

    @NotNull
    public static MTagCompound getNBT(@NotNull File pFile) throws IOException {
        try (DataInputStream dataInputStream = SchematicUtil.getStream(pFile);){
            MTagCompound mTagCompound = CompressedStreamTools.read(dataInputStream);
            return mTagCompound;
        }
    }

    @NotNull
    private static DataInputStream getStream(@NotNull File pFile) throws IOException {
        return new DataInputStream(new GZIPInputStream(new FileInputStream(pFile)));
    }

    @NotNull
    public static IDim dimension(@NotNull MTagCompound pNBT) {
        int length = pNBT.getInt("Width");
        int width = pNBT.getInt("Length");
        int height = pNBT.getInt("Height");
        return new Dim(width, height, length);
    }

    @NotNull
    public static IOffset offset(@NotNull MTagCompound pNBT) {
        int offsetX = 0;
        if (pNBT.hasKey("WEOffsetX")) {
            offsetX = pNBT.getInt("WEOffsetX");
        }
        int offsetY = 0;
        if (pNBT.hasKey("WEOffsetY")) {
            offsetY = pNBT.getInt("WEOffsetY");
        }
        int offsetZ = 0;
        if (pNBT.hasKey("WEOffsetZ")) {
            offsetZ = pNBT.getInt("WEOffsetZ");
        }
        return new Offset(offsetX, offsetY, offsetZ);
    }

    private static int countBlocks(byte[] pPureIDs) {
        int quantity = 0;
        for (byte pureID : pPureIDs) {
            if (pureID == 0) continue;
            ++quantity;
        }
        return quantity;
    }
}

