/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.place;

import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.mapper.EDirection;
import de.maggicraft.ism.mapper.EMirror;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.world.boundingbox.EBoundingBoxState;
import de.maggicraft.ism.world.place.EPlaceProgressType;
import de.maggicraft.ism.world.place.EPlaceStructureState;
import de.maggicraft.ism.world.place.IPlaceStructureProgress;
import de.maggicraft.ism.world.place.IPlaceStructureServer;
import de.maggicraft.ism.world.place.ITrackedPlaceStructure;
import de.maggicraft.ism.world.place.PlaceStructureProgress;
import de.maggicraft.ism.world.place.TrackedPlaceStructure;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mcommons.timer.Timer;
import de.maggicraft.mcommons.util.MTuple;
import java.io.File;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlaceStructureServer
implements IPlaceStructureServer {
    private final Semaphore mSemaphore = new Semaphore(1);
    protected Exception mThrownByThread = null;
    protected int mMaxBlocksQuantity = 0;
    protected int mMaxLightsQuantity = 0;
    protected int mMaxChunksQuantity = 0;
    protected int mMaxEntitiesQuantity = 0;
    protected int mBlocksQuantity = 0;
    protected int mLightsQuantity = 0;
    protected int mChunksQuantity = 0;
    protected int mEntitiesQuantity = 0;
    @NotNull
    private Set<EPlaceStructureState> mStates = new CopyOnWriteArraySet<EPlaceStructureState>();
    @NotNull
    private File mBackupFile = new File(".");
    @NotNull
    private Timer mTimerTotal = new Timer();
    @NotNull
    private EPlaceProgressType mPlaceProgressType = EPlaceProgressType.NOT_DETERMINED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final MTuple<ITrackedPlaceStructure, File> placeStructure(@NotNull File pStructureFile, @NotNull IPos pPos, @NotNull EDirection pDirection, @NotNull EMirror pMirror, boolean pPlaceAir) throws StorageException {
        if (!this.mSemaphore.tryAcquire()) {
            throw new IllegalStateException();
        }
        try {
            this.mTimerTotal.startTimer();
            CountDownLatch awaitInitialization = new CountDownLatch(2);
            this.threadInitializationStructure(awaitInitialization, pStructureFile, pPos, pDirection, pMirror);
            this.threadInitializationWorld(awaitInitialization);
            this.awaitInitialization(awaitInitialization);
            if (this.mPlaceProgressType == EPlaceProgressType.PLACE_COMPACT) {
                ITrackedPlaceStructure tracked = this.processCompact(pPlaceAir);
                this.mStates.add(EPlaceStructureState.FINISHED);
                MTuple<ITrackedPlaceStructure, File> mTuple = new MTuple<ITrackedPlaceStructure, File>(tracked, this.mBackupFile);
                return mTuple;
            }
            if (this.mPlaceProgressType == EPlaceProgressType.PLACE_EXTENDED) {
                ITrackedPlaceStructure tracked = this.processExtended(pPlaceAir);
                this.mStates.add(EPlaceStructureState.FINISHED);
                MTuple<ITrackedPlaceStructure, File> mTuple = new MTuple<ITrackedPlaceStructure, File>(tracked, this.mBackupFile);
                return mTuple;
            }
            throw new IllegalStateException();
        }
        finally {
            try {
                this.cleanMinecraftIndependent();
                this.cleanMinecraftDependent();
            }
            finally {
                this.mSemaphore.release();
            }
        }
    }

    private void threadInitializationStructure(@NotNull CountDownLatch pAwaitInitialization, @NotNull File pStructureFile, @NotNull IPos pPos, @NotNull EDirection pDirection, @NotNull EMirror pMirror) {
        new Thread(() -> {
            try {
                this.mStates.add(EPlaceStructureState.READING_STRUCTURE);
                IDim structureDim = this.readStructure(pStructureFile);
                this.mPlaceProgressType = this.determinePlaceProgress();
                this.createPosTranslator(pPos, structureDim, pDirection, pMirror);
                this.mStates.remove(EPlaceStructureState.READING_STRUCTURE);
            }
            catch (Exception pE) {
                this.mThrownByThread = pE;
            }
            finally {
                pAwaitInitialization.countDown();
            }
        }).start();
    }

    private void threadInitializationWorld(@NotNull CountDownLatch pAwaitInitialization) {
        new Thread(() -> {
            try {
                if (MCContainer.getBoundingBox().getState() == EBoundingBoxState.PLACED) {
                    this.mStates.add(EPlaceStructureState.REMOVING_BOUNDING_BOX);
                    MCContainer.getBoundingBox().remove();
                    this.mStates.remove(EPlaceStructureState.REMOVING_BOUNDING_BOX);
                }
                this.mStates.add(EPlaceStructureState.CREATING_BACKUP);
                this.mBackupFile = this.createBackup();
                this.mStates.remove(EPlaceStructureState.CREATING_BACKUP);
            }
            catch (Exception pE) {
                this.mThrownByThread = pE;
            }
            finally {
                pAwaitInitialization.countDown();
            }
        }).start();
    }

    private void awaitInitialization(@NotNull CountDownLatch pAwaitInitialization) throws StorageException {
        try {
            pAwaitInitialization.await();
            if (this.mThrownByThread != null) {
                throw new StorageException(EStorageException.PROGRAMMING_ERROR, "thrown by thread", this.mThrownByThread);
            }
        }
        catch (InterruptedException pE) {
            throw new StorageException(EStorageException.PROGRAMMING_ERROR, "awaitingInitialization", pE);
        }
    }

    @NotNull
    protected abstract IDim readStructure(@NotNull File var1) throws StorageException;

    @NotNull
    protected abstract EPlaceProgressType determinePlaceProgress();

    protected abstract void createPosTranslator(@NotNull IPos var1, @NotNull IDim var2, @NotNull EDirection var3, @NotNull EMirror var4);

    @NotNull
    protected abstract File createBackup();

    @NotNull
    private ITrackedPlaceStructure processCompact(boolean pPlaceAir) {
        Timer timerBlocks = new Timer().startTimer();
        this.mStates.add(EPlaceStructureState.PLACING_BLOCKS);
        this.placeBlocksCompact(pPlaceAir);
        this.mStates.remove(EPlaceStructureState.PLACING_BLOCKS);
        timerBlocks.stopTimer();
        Timer timerEntities = new Timer().startTimer();
        this.mStates.add(EPlaceStructureState.ADDING_ENTITIES);
        this.addEntities();
        this.mStates.remove(EPlaceStructureState.ADDING_ENTITIES);
        timerEntities.stopTimer();
        this.reloadWorld();
        this.mTimerTotal.stopTimer();
        return new TrackedPlaceStructure(this.mTimerTotal.getTime(), timerBlocks.getTime(), 0L, 0L, timerEntities.getTime(), this.mBlocksQuantity, 0, 0, this.mEntitiesQuantity);
    }

    @NotNull
    private ITrackedPlaceStructure processExtended(boolean pPlaceAir) throws StorageException {
        Timer timerBlocks = new Timer().startTimer();
        this.mStates.add(EPlaceStructureState.PLACING_BLOCKS);
        this.placeBlocksExtended(pPlaceAir);
        this.mStates.remove(EPlaceStructureState.PLACING_BLOCKS);
        timerBlocks.stopTimer();
        CountDownLatch awaitLightsChunks = new CountDownLatch(2);
        Timer timerLights = new Timer();
        new Thread(() -> {
            try {
                timerLights.startTimer();
                this.mStates.add(EPlaceStructureState.UPDATING_LIGHTS);
                this.updateLights();
                this.mStates.remove(EPlaceStructureState.UPDATING_LIGHTS);
                timerLights.stopTimer();
            }
            catch (Exception pE) {
                this.mThrownByThread = pE;
            }
            finally {
                awaitLightsChunks.countDown();
            }
        }).start();
        Timer timerChunks = new Timer();
        new Thread(() -> {
            try {
                timerChunks.startTimer();
                this.mStates.add(EPlaceStructureState.UPDATING_CHUNKS);
                this.updateChunks();
                this.mStates.remove(EPlaceStructureState.UPDATING_CHUNKS);
                timerChunks.stopTimer();
            }
            catch (Exception pE) {
                this.mThrownByThread = pE;
            }
            finally {
                awaitLightsChunks.countDown();
            }
        }).start();
        try {
            awaitLightsChunks.await();
            if (this.mThrownByThread != null) {
                throw new StorageException(EStorageException.PROGRAMMING_ERROR, "thrown by thread", this.mThrownByThread);
            }
        }
        catch (InterruptedException pE) {
            throw new StorageException(EStorageException.PROGRAMMING_ERROR, "awaitLightsChunks", pE);
        }
        Timer timerEntities = new Timer().startTimer();
        this.mStates.add(EPlaceStructureState.ADDING_ENTITIES);
        this.addEntities();
        this.mStates.remove(EPlaceStructureState.ADDING_ENTITIES);
        timerEntities.stopTimer();
        this.reloadWorld();
        this.mTimerTotal.stopTimer();
        return new TrackedPlaceStructure(this.mTimerTotal.getTime(), timerBlocks.getTime(), timerLights.getTime(), timerChunks.getTime(), timerEntities.getTime(), this.mBlocksQuantity, this.mLightsQuantity, this.mChunksQuantity, this.mEntitiesQuantity);
    }

    protected abstract void placeBlocksCompact(boolean var1);

    protected abstract void placeBlocksExtended(boolean var1);

    protected abstract void updateLights();

    protected abstract void updateChunks();

    protected abstract void addEntities();

    protected abstract void reloadWorld();

    private void cleanMinecraftIndependent() {
        this.mThrownByThread = null;
        this.mMaxBlocksQuantity = 0;
        this.mMaxLightsQuantity = 0;
        this.mMaxChunksQuantity = 0;
        this.mBlocksQuantity = 0;
        this.mLightsQuantity = 0;
        this.mChunksQuantity = 0;
        this.mStates = new CopyOnWriteArraySet<EPlaceStructureState>();
        this.mBackupFile = new File(".");
        this.mTimerTotal = new Timer();
        this.mPlaceProgressType = EPlaceProgressType.NOT_DETERMINED;
    }

    protected abstract void cleanMinecraftDependent();

    @Override
    @NotNull
    public final IPlaceStructureProgress captureProgress() {
        return new PlaceStructureProgress(this.mStates, this.mMaxBlocksQuantity, this.mMaxLightsQuantity, this.mMaxChunksQuantity, this.mMaxEntitiesQuantity, this.mBlocksQuantity, this.mLightsQuantity, this.mChunksQuantity, this.mEntitiesQuantity);
    }

    @Override
    @NotNull
    public final EPlaceProgressType getPlaceType() {
        return this.mPlaceProgressType;
    }
}

