/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.place;

import de.maggicraft.ism.world.place.EPlaceStructureState;
import de.maggicraft.ism.world.place.IPlaceStructureProgress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PlaceStructureProgress
implements IPlaceStructureProgress {
    @NotNull
    private final EPlaceStructureState[] mStates;
    private final int mMaxBlocks;
    private final int mMaxLights;
    private final int mMaxChunks;
    private final int mMaxEntities;
    private final int mCurrentBlocks;
    private final int mCurrentLights;
    private final int mCurrentChunks;
    private final int mCurrentEntities;

    public PlaceStructureProgress(@NotNull Set<EPlaceStructureState> pStates, int pMaxBlocks, int pMaxLights, int pMaxChunks, int pMaxEntities, int pCurrentBlocks, int pCurrentLights, int pCurrentChunks, int pCurrentEntities) {
        this.mStates = new EPlaceStructureState[pStates.size()];
        int i = 0;
        Iterator<EPlaceStructureState> iterator = pStates.iterator();
        while (iterator.hasNext()) {
            EPlaceStructureState state;
            this.mStates[i] = state = iterator.next();
            ++i;
        }
        this.mMaxBlocks = pMaxBlocks;
        this.mMaxLights = pMaxLights;
        this.mMaxChunks = pMaxChunks;
        this.mMaxEntities = pMaxEntities;
        this.mCurrentBlocks = pCurrentBlocks;
        this.mCurrentLights = pCurrentLights;
        this.mCurrentChunks = pCurrentChunks;
        this.mCurrentEntities = pCurrentEntities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PlaceStructureProgress{");
        sb.append("mStates=").append(Arrays.toString(this.mStates));
        sb.append(", mMaxBlocks=").append(this.mMaxBlocks);
        sb.append(", mMaxLights=").append(this.mMaxLights);
        sb.append(", mMaxChunks=").append(this.mMaxChunks);
        sb.append(", mMaxEntities=").append(this.mMaxEntities);
        sb.append(", mCurrentBlocks=").append(this.mCurrentBlocks);
        sb.append(", mCurrentLights=").append(this.mCurrentLights);
        sb.append(", mCurrentChunks=").append(this.mCurrentChunks);
        sb.append(", mCurrentEntities=").append(this.mCurrentEntities);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        PlaceStructureProgress that = (PlaceStructureProgress)pO;
        return this.mMaxBlocks == that.mMaxBlocks && this.mMaxLights == that.mMaxLights && this.mMaxChunks == that.mMaxChunks && this.mMaxEntities == that.mMaxEntities && this.mCurrentBlocks == that.mCurrentBlocks && this.mCurrentLights == that.mCurrentLights && this.mCurrentChunks == that.mCurrentChunks && this.mCurrentEntities == that.mCurrentEntities && Arrays.equals(this.mStates, that.mStates);
    }

    public int hashCode() {
        int result = Objects.hash(this.mMaxBlocks, this.mMaxLights, this.mMaxChunks, this.mMaxEntities, this.mCurrentBlocks, this.mCurrentLights, this.mCurrentChunks, this.mCurrentEntities);
        result = 31 * result + Arrays.hashCode(this.mStates);
        return result;
    }

    @Override
    @NotNull
    public EPlaceStructureState[] getStates() {
        return this.mStates;
    }

    @Override
    public int getMaxBlocks() {
        return this.mMaxBlocks;
    }

    @Override
    public int getMaxLights() {
        return this.mMaxLights;
    }

    @Override
    public int getMaxChunks() {
        return this.mMaxChunks;
    }

    @Override
    public int getMaxEntities() {
        return this.mMaxEntities;
    }

    @Override
    public int getCurrentEntities() {
        return this.mCurrentEntities;
    }

    @Override
    public int getCurrentBlocks() {
        return this.mCurrentBlocks;
    }

    @Override
    public int getCurrentLights() {
        return this.mCurrentLights;
    }

    @Override
    public int getCurrentChunks() {
        return this.mCurrentChunks;
    }
}

