/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.place;

import de.maggicraft.ism.mapper.CreateTranslators;
import de.maggicraft.ism.mapper.EDirection;
import de.maggicraft.ism.mapper.EMirror;
import de.maggicraft.ism.mapper.IPosTranslator;
import de.maggicraft.ism.mapper.StateTranslators;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.world.place.AbstractPlaceStructureServer;
import de.maggicraft.ism.world.place.EPlaceProgressType;
import de.maggicraft.ism.world.place.IStructure;
import de.maggicraft.ism.world.place.Schematic;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.ism.world.util.WorldStateUtil;
import java.io.File;
import java.io.IOException;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class PlaceStructureServer
extends AbstractPlaceStructureServer {
    private IStructure mStructure;
    private IPosTranslator mPosTranslator;

    @Override
    @NotNull
    protected IDim readStructure(@NotNull File pFile) throws StorageException {
        try {
            this.mStructure = new Schematic(pFile, StateTranslators.IDENTITY);
            return this.mStructure.getDim();
        }
        catch (IOException pE) {
            throw new StorageException(EStorageException.COMPOUND, "", pE);
        }
    }

    @Override
    @NotNull
    protected EPlaceProgressType determinePlaceProgress() {
        return EPlaceProgressType.PLACE_COMPACT;
    }

    @Override
    protected void createPosTranslator(@NotNull IPos pPos, @NotNull IDim pDim, @NotNull EDirection pDirection, @NotNull EMirror pMirror) {
        this.mPosTranslator = CreateTranslators.createTranslator(pPos, pDim, pDirection, pMirror);
    }

    @Override
    @NotNull
    protected File createBackup() {
        return new File(".");
    }

    @Override
    protected void placeBlocksCompact(boolean pPlaceAir) {
        IDim dim = this.mStructure.getDim();
        this.mMaxBlocksQuantity = dim.getVolume();
        int dimX = dim.getX();
        int dimY = dim.getY();
        int dimZ = dim.getZ();
        BlockState airState = Blocks.field_150350_a.func_176223_P();
        for (int y = 0; y < dimY; ++y) {
            for (int x = 0; x < dimX; ++x) {
                for (int z = 0; z < dimZ; ++z) {
                    BlockState state = this.mStructure.readState();
                    if (pPlaceAir || state != airState) {
                        WorldStateUtil.getWorld().func_175656_a(this.mPosTranslator.translate(x, y, z), state);
                    }
                    ++this.mBlocksQuantity;
                }
            }
        }
    }

    @Override
    protected void placeBlocksExtended(boolean pPlaceAir) {
    }

    @Override
    protected void updateLights() {
    }

    @Override
    protected void updateChunks() {
    }

    @Override
    protected void addEntities() {
    }

    @Override
    protected void reloadWorld() {
    }

    @Override
    protected void cleanMinecraftDependent() {
        this.mStructure = null;
        this.mPosTranslator = null;
    }
}

