/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.place;

import de.maggicraft.ism.analytics.server.TrackAction;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.mapper.EDirection;
import de.maggicraft.ism.mapper.EMirror;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.world.place.IPlaceStructureProgress;
import de.maggicraft.ism.world.place.IPlaceStructureServer;
import de.maggicraft.ism.world.place.IPlaceStructureWrapper;
import de.maggicraft.ism.world.place.ITrackedPlaceStructure;
import de.maggicraft.ism.world.place.PlaceProgressDialog;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mcommons.util.MTuple;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;

public class PlaceStructureWrapper
implements IPlaceStructureWrapper {
    private IPlaceStructureServer mPlaceStructure;
    private boolean mRunning = false;
    private boolean mErrorOccurred = false;

    private static String createFreeText(@NotNull IPos pPos, @NotNull EDirection pDirection, @NotNull EMirror pMirror, boolean pPlaceAir) {
        StringBuilder dim = new StringBuilder();
        dim.append("x: ").append(pPos.getX());
        dim.append(", y: ").append(pPos.getY());
        dim.append(", z: ").append(pPos.getZ());
        dim.append(", rot: ").append(pDirection.getUID());
        dim.append(", ").append(pMirror.getUID());
        if (pPlaceAir) {
            dim.append(", placeAir");
        }
        return dim.toString();
    }

    @Override
    public void initialize() {
        try {
            ISMContainer.getMCLoaderServer().requiredPlaceStructureServer();
            this.mPlaceStructure = (IPlaceStructureServer)ISMContainer.getRegistry().lookup("placeStructure");
        }
        catch (NotBoundException | RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void placeStructure(@NotNull File pStructureFile, @NotNull IPos pPos, @NotNull EDirection pDirection, @NotNull EMirror pMirror, boolean pPlaceAir, @NotNull String pURL) throws StorageException {
        this.mRunning = true;
        this.mErrorOccurred = false;
        this.process();
        try {
            MTuple<ITrackedPlaceStructure, File> tuple = this.mPlaceStructure.placeStructure(pStructureFile, pPos, pDirection, pMirror, pPlaceAir);
            System.out.println("backup file: " + tuple.getB());
            this.mRunning = false;
            TrackAction.trackPlaceStructure(tuple.getA(), pURL, PlaceStructureWrapper.createFreeText(pPos, pDirection, pMirror, pPlaceAir));
        }
        catch (StorageException | RemoteException pE) {
            this.mErrorOccurred = true;
            this.mRunning = false;
            ISMContainer.getLogger().log(pE);
        }
        finally {
            this.mRunning = false;
        }
    }

    private void process() {
        new Thread(() -> {
            PlaceProgressDialog progressDialog = new PlaceProgressDialog();
            try {
                IPlaceStructureProgress progress = this.captureProgress();
                while (this.mRunning) {
                    progressDialog.iterate(progress);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException pE) {
                        pE.printStackTrace();
                    }
                    progress = this.captureProgress();
                }
                if (this.mErrorOccurred) {
                    System.out.println("error occurred!");
                } else {
                    System.out.println("placed structure successfully!");
                }
            }
            finally {
                progressDialog.dispose();
            }
        }).start();
    }

    @NotNull
    private IPlaceStructureProgress captureProgress() {
        try {
            return this.mPlaceStructure.captureProgress();
        }
        catch (RemoteException pE) {
            ISMContainer.getLogger().log(pE);
            this.mErrorOccurred = true;
            this.mRunning = false;
            throw new IllegalArgumentException();
        }
    }
}

