/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.place;

import de.maggicraft.ism.mapper.IPlaceBlockTable;
import de.maggicraft.ism.mapper.IStateTranslator;
import de.maggicraft.ism.mapper.PlaceBlockTable;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.world.nbt.MTagCompound;
import de.maggicraft.ism.world.nbt.SchematicUtil;
import de.maggicraft.ism.world.place.ISchematic;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IOffset;
import java.io.File;
import java.io.IOException;
import net.minecraft.block.BlockState;
import org.jetbrains.annotations.NotNull;

public class Schematic
implements ISchematic {
    public static final int MAX_BLOCKS = 175000000;
    @NotNull
    private final IDim mDim;
    @NotNull
    private final IOffset mOffset;
    @NotNull
    private byte[] mBlockIDs;
    @NotNull
    private byte[] mMetas;
    @NotNull
    private IPlaceBlockTable mTable;
    private int mIndex = 0;

    public Schematic(@NotNull File pSchematic, @NotNull IStateTranslator pTranslator) throws IOException, StorageException {
        MTagCompound nbt = SchematicUtil.getNBT(pSchematic);
        this.mDim = SchematicUtil.dimension(nbt);
        this.checkVolume();
        this.mOffset = SchematicUtil.offset(nbt);
        this.mBlockIDs = nbt.getByteArray("Blocks");
        this.mMetas = nbt.getByteArray("Data");
        this.mTable = new PlaceBlockTable(pTranslator);
    }

    private void checkVolume() throws StorageException {
        int volume = this.mDim.getVolume();
        if (this.mDim.getVolume() > 175000000) {
            throw new StorageException(EStorageException.CONVERT_DEFAULT, "too large structure");
        }
        if (volume == 0) {
            throw new StorageException(EStorageException.CONVERT_DEFAULT, "no dim");
        }
    }

    @Override
    @NotNull
    public BlockState readState() {
        byte blockID = this.mBlockIDs[this.mIndex];
        byte meta = this.mMetas[this.mIndex];
        ++this.mIndex;
        return this.mTable.get(blockID & 0xFF, meta);
    }

    @Override
    public void close() {
        this.mBlockIDs = new byte[0];
        this.mMetas = new byte[0];
        this.mTable = PlaceBlockTable.EMPTY_TABLE;
    }

    @Override
    @NotNull
    public IDim getDim() {
        return this.mDim;
    }

    @Override
    @NotNull
    public IOffset getOffset() {
        return this.mOffset;
    }
}

