/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.remove;

import de.maggicraft.ism.analytics.server.IActionTracking;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.world.remove.IRemovableStructure;
import de.maggicraft.ism.world.remove.IRemoveStructureServer;
import de.maggicraft.ism.world.remove.IRemoveStructureWrapper;
import de.maggicraft.ism.world.util.IPos;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;

public class RemoveStructureWrapper
implements IRemoveStructureWrapper {
    private IRemoveStructureServer mRemoveStructure;

    @Override
    public void initialize() {
        try {
            ISMContainer.getMCLoaderServer().requiredRemoveStructureServer();
            this.mRemoveStructure = (IRemoveStructureServer)ISMContainer.getRegistry().lookup("removeStructure");
        }
        catch (NotBoundException | RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    public void remove(@NotNull IActionTracking pTracking, @NotNull IRemovableStructure pPlaced, @NotNull IPos pCorner) throws StorageException {
        try {
            this.mRemoveStructure.remove(pTracking, pPlaced, pCorner);
        }
        catch (RemoteException pE) {
            throw new StorageException(EStorageException.REMOTE_EXCEPTION, "remote exception", pE);
        }
    }
}

