/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.repos;

import de.maggicraft.ism.analytics.server.IActionTracking;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.world.repos.IReposBackupStructure;
import de.maggicraft.ism.world.repos.IReposStructure;
import de.maggicraft.ism.world.repos.IReposStructureServer;
import de.maggicraft.ism.world.repos.IReposStructureWrapper;
import de.maggicraft.ism.world.util.IFilterInput;
import de.maggicraft.ism.world.util.IPos;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;

public class ReposStructureWrapper
implements IReposStructureWrapper {
    private IReposStructureServer mReposStructure;

    @Override
    public void initialize() {
        try {
            ISMContainer.getMCLoaderServer().requiredReposStructureServer();
            this.mReposStructure = (IReposStructureServer)ISMContainer.getRegistry().lookup("reposStructure");
        }
        catch (NotBoundException | RemoteException pE) {
            ISMContainer.getLogger().log(pE);
        }
    }

    @Override
    @NotNull
    public File reposition(@NotNull IActionTracking pTracking, @NotNull IReposBackupStructure pBackup, @NotNull IReposStructure pRepos, @NotNull IFilterInput pFilterInput, @NotNull IPos pCorner, int pDimX, int pDimZ, boolean pFlatten) throws StorageException {
        try {
            return this.mReposStructure.reposition(pTracking, pBackup, pRepos, pFilterInput, pCorner, pDimX, pDimZ, pFlatten);
        }
        catch (RemoteException pE) {
            throw new StorageException(EStorageException.REMOTE_EXCEPTION, "remote exception", pE);
        }
    }
}

