/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.util;

import de.maggicraft.ism.world.util.I3Vec;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public final class Dim
implements IDim {
    public static final Dim EMPTY_DIM = new Dim(0, 0, 0);
    private final int mDimX;
    private final int mDimY;
    private final int mDimZ;

    public Dim(int pDimX, int pDimY, int pDimZ) {
        this.mDimX = pDimX;
        this.mDimY = pDimY;
        this.mDimZ = pDimZ;
    }

    public Dim(@NotNull JSONObject pJSON) {
        this.mDimX = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.X);
        this.mDimY = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.Y);
        this.mDimZ = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.Z);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Dimension{");
        sb.append("mDimX=").append(this.mDimX);
        sb.append(", mDimY=").append(this.mDimY);
        sb.append(", mDimZ=").append(this.mDimZ);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        Dim dimension = (Dim)pO;
        return this.mDimX == dimension.mDimX && this.mDimY == dimension.mDimY && this.mDimZ == dimension.mDimZ;
    }

    public int hashCode() {
        return Objects.hash(this.mDimX, this.mDimY, this.mDimZ);
    }

    @Override
    public int getX() {
        return this.mDimX;
    }

    @Override
    public int getY() {
        return this.mDimY;
    }

    @Override
    public int getZ() {
        return this.mDimZ;
    }
}

