/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.util;

import de.maggicraft.ism.world.util.IMinecraftUtil;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.ism.world.util.Pos;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinecraftUtil
implements IMinecraftUtil {
    @Nullable
    private static PlayerEntity sPlayer;

    public static void dropItem(@NotNull Item pItem) {
        if (sPlayer == null) {
            throw NO_WORLD_LOADED;
        }
        sPlayer.func_199703_a((IItemProvider)pItem);
    }

    @NotNull
    public static IPos convertPos(@NotNull BlockPos pPos) {
        return new Pos(pPos.func_177958_n(), pPos.func_177956_o(), pPos.func_177952_p());
    }

    @NotNull
    public static BlockPos convertPos(@NotNull IPos pPos) {
        return new BlockPos(pPos.getX(), pPos.getY(), pPos.getZ());
    }

    @NotNull
    public static PlayerEntity getPlayer() {
        if (sPlayer == null) {
            throw NO_WORLD_LOADED;
        }
        return sPlayer;
    }

    @NotNull
    public static IPos getPlayerPos(@NotNull PlayerEntity pPlayer) {
        int posX = (int)Math.round(pPlayer.func_226277_ct_() - 0.5);
        int posY = (int)Math.round(pPlayer.func_226278_cu_() - 0.5);
        int posZ = (int)Math.round(pPlayer.func_226281_cx_() - 0.5);
        return new Pos(posX, posY, posZ);
    }

    public static void setPlayer(@Nullable PlayerEntity pPlayer) {
        sPlayer = pPlayer;
    }

    @Override
    public void chatSingleLine(@NotNull String pText) throws IllegalStateException {
        if (sPlayer == null) {
            throw NO_WORLD_LOADED;
        }
        sPlayer.func_146105_b((ITextComponent)new StringTextComponent(pText), true);
    }

    @Override
    public void ensureWorldLoaded() throws IllegalStateException {
        if (sPlayer == null) {
            throw NO_WORLD_LOADED;
        }
    }

    @Override
    public void displayCrashReport(@NotNull String pTitle, @NotNull Throwable pThrowable) {
        CrashReport crashReport = new CrashReport(pTitle, pThrowable);
        Minecraft.func_71410_x();
        Minecraft.func_71377_b((CrashReport)crashReport);
    }
}

