/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.util;

import de.maggicraft.ism.world.util.I3Vec;
import de.maggicraft.ism.world.util.IOffset;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public final class Offset
implements IOffset {
    private final int mOffsetX;
    private final int mOffsetY;
    private final int mOffsetZ;

    public Offset(int pOffsetX, int pOffsetY, int pOffsetZ) {
        this.mOffsetX = pOffsetX;
        this.mOffsetY = pOffsetY;
        this.mOffsetZ = pOffsetZ;
    }

    public Offset(@NotNull JSONObject pJSON) {
        this.mOffsetX = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.X);
        this.mOffsetY = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.Y);
        this.mOffsetZ = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.Z);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Offset{");
        sb.append("mOffsetX=").append(this.mOffsetX);
        sb.append(", mOffsetY=").append(this.mOffsetY);
        sb.append(", mOffsetZ=").append(this.mOffsetZ);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        Offset offset = (Offset)pO;
        return this.mOffsetX == offset.mOffsetX && this.mOffsetY == offset.mOffsetY && this.mOffsetZ == offset.mOffsetZ;
    }

    public int hashCode() {
        return Objects.hash(this.mOffsetX, this.mOffsetY, this.mOffsetZ);
    }

    @Override
    public int getX() {
        return this.mOffsetX;
    }

    @Override
    public int getY() {
        return this.mOffsetY;
    }

    @Override
    public int getZ() {
        return this.mOffsetZ;
    }
}

