/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.util;

import de.maggicraft.ism.world.util.I3Vec;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.util.Objects;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public final class Pos
implements IPos {
    public static final long X_MASK = 0x3FFFFFFL;
    public static final long Y_MASK = 4095L;
    public static final long Z_MASK = 0x3FFFFFFL;
    public static final long X_SHIFT = 38L;
    public static final long Y_SHIFT = 26L;
    public static final int NUM_X_BITS = 26;
    public static final int NUM_Y_BITS = 12;
    public static final int NUM_Z_BITS = 26;
    private final int mX;
    private final int mY;
    private final int mZ;

    public Pos(@NotNull Random pRandom) {
        this.mX = pRandom.nextInt(2048) - 1024;
        this.mY = pRandom.nextInt(256);
        this.mZ = pRandom.nextInt(2048) - 1024;
    }

    public Pos(int pX, int pY, int pZ) {
        this.mX = pX;
        this.mY = pY;
        this.mZ = pZ;
    }

    public Pos(@NotNull JSONObject pJSON) {
        this.mX = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.X);
        this.mY = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.Y);
        this.mZ = ReadableUtil.getInt(pJSON, I3Vec.E3VecKeys.Z);
    }

    public Pos(long pLong) {
        this.mX = (int)(pLong << 0 >> 38);
        this.mY = (int)(pLong << 26 >> 52);
        this.mZ = (int)(pLong << 38 >> 38);
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        if (pObject == null || this.getClass() != pObject.getClass()) {
            return false;
        }
        Pos blockPos = (Pos)pObject;
        return this.mX == blockPos.mX && this.mY == blockPos.mY && this.mZ == blockPos.mZ;
    }

    public int hashCode() {
        return Objects.hash(this.mX, this.mY, this.mZ);
    }

    public String toString() {
        return "Pos{mX=" + this.mX + ", mY=" + this.mY + ", mZ=" + this.mZ + '}';
    }

    @Override
    @NotNull
    public IPos center(@NotNull IDim pDim) {
        int cornerX = this.mX + Math.round((float)pDim.getX() / 2.0f);
        int cornerY = this.mY + Math.round((float)pDim.getX() / 2.0f);
        int cornerZ = this.mZ + Math.round((float)pDim.getX() / 2.0f);
        return new Pos(cornerX, cornerY, cornerZ);
    }

    @Override
    public long toLong() {
        return ((long)this.mX & 0x3FFFFFFL) << 38 | ((long)this.mY & 0xFFFL) << 26 | (long)this.mZ & 0x3FFFFFFL;
    }

    @Override
    public int getX() {
        return this.mX;
    }

    @Override
    public int getY() {
        return this.mY;
    }

    @Override
    public int getZ() {
        return this.mZ;
    }
}

