/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.world.util;

import de.maggicraft.ism.world.util.IStrMetadata;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class StrMetadata
implements IStrMetadata {
    @NotNull
    private final String mStructureName;
    @NotNull
    private final String mCreatorName;
    @NotNull
    private final String mDescription;
    @NotNull
    private final String mTags;
    @NotNull
    private final String mURL;
    private final int mGenreID;

    public StrMetadata(@NotNull String pStructureName, @NotNull String pCreatorName, @NotNull String pDescription, @NotNull String[] pTags, @NotNull String pURL, int pGenreID) {
        this(pStructureName, pCreatorName, pDescription, StrMetadata.convertTags(pTags), pURL, pGenreID);
    }

    public StrMetadata(@NotNull String pStructureName, @NotNull String pCreatorName, @NotNull String pDescription, @NotNull String pTags, @NotNull String pURL, int pGenreID) {
        this.mStructureName = pStructureName;
        this.mCreatorName = pCreatorName;
        this.mDescription = pDescription;
        this.mTags = pTags;
        this.mURL = pURL;
        this.mGenreID = pGenreID;
    }

    @NotNull
    private static String convertTags(String[] pTags) {
        StringBuilder sb = new StringBuilder();
        for (String tag : pTags) {
            sb.append(tag).append(' ');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StrMetadata{");
        sb.append("mStructureName='").append(this.mStructureName).append('\'');
        sb.append(", mCreatorName='").append(this.mCreatorName).append('\'');
        sb.append(", mDescription='").append(this.mDescription).append('\'');
        sb.append(", mTags='").append(this.mTags).append('\'');
        sb.append(", mURL='").append(this.mURL).append('\'');
        sb.append(", mGenreID=").append(this.mGenreID);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        StrMetadata that = (StrMetadata)pO;
        return this.mGenreID == that.mGenreID && this.mStructureName.equals(that.mStructureName) && this.mCreatorName.equals(that.mCreatorName) && this.mDescription.equals(that.mDescription) && this.mTags.equals(that.mTags) && this.mURL.equals(that.mURL);
    }

    public int hashCode() {
        return Objects.hash(this.mStructureName, this.mCreatorName, this.mDescription, this.mTags, this.mURL, this.mGenreID);
    }

    @Override
    @NotNull
    public String getStructureName() {
        return this.mStructureName;
    }

    @Override
    @NotNull
    public String getCreatorName() {
        return this.mCreatorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    @NotNull
    public String getTags() {
        return this.mTags;
    }

    @Override
    @NotNull
    public String getURL() {
        return this.mURL;
    }

    @Override
    public int getGenreID() {
        return this.mGenreID;
    }
}

