/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.manalytics;

import de.maggicraft.manalytics.GoogleAnalytics;
import de.maggicraft.manalytics.GoogleAnalyticsConfig;
import de.maggicraft.manalytics.discovery.DefaultRequestParameterDiscoverer;
import de.maggicraft.manalytics.discovery.RequestParameterDiscoverer;
import de.maggicraft.manalytics.httpclient.ApacheHttpClientImpl;
import de.maggicraft.manalytics.httpclient.HttpClient;
import de.maggicraft.manalytics.internal.GaUtils;
import de.maggicraft.manalytics.internal.GoogleAnalyticsImpl;
import de.maggicraft.manalytics.internal.GoogleAnalyticsThreadFactory;
import de.maggicraft.manalytics.request.DefaultRequest;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GoogleAnalyticsBuilder {
    private GoogleAnalyticsConfig config = new GoogleAnalyticsConfig();
    private DefaultRequest defaultRequest = new DefaultRequest();
    private HttpClient httpClient;
    private ExecutorService executor;

    public GoogleAnalyticsBuilder withConfig(GoogleAnalyticsConfig config) {
        this.config = GaUtils.firstNotNull(config, new GoogleAnalyticsConfig());
        return this;
    }

    public GoogleAnalyticsBuilder withTrackingId(String trackingId) {
        this.defaultRequest.trackingId(trackingId);
        return this;
    }

    public GoogleAnalyticsBuilder withAppName(String value) {
        this.defaultRequest.applicationName(value);
        return this;
    }

    public GoogleAnalyticsBuilder withAppVersion(String value) {
        this.defaultRequest.applicationVersion(value);
        return this;
    }

    public GoogleAnalyticsBuilder withDefaultRequest(DefaultRequest defaultRequest) {
        this.defaultRequest = GaUtils.firstNotNull(defaultRequest, new DefaultRequest());
        return this;
    }

    public GoogleAnalyticsBuilder withExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public GoogleAnalyticsBuilder withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public GoogleAnalytics build() {
        if (this.config.isDiscoverRequestParameters()) {
            RequestParameterDiscoverer discoverer = GaUtils.firstNotNull(this.config.getRequestParameterDiscoverer(), DefaultRequestParameterDiscoverer.INSTANCE);
            discoverer.discoverParameters(this.config, this.defaultRequest);
        }
        return new GoogleAnalyticsImpl(this.config, this.defaultRequest, this.createHttpClient(), this.createExecutor());
    }

    protected HttpClient createHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        return new ApacheHttpClientImpl(this.config);
    }

    protected ExecutorService createExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        return new ThreadPoolExecutor(this.config.getMinThreads(), this.config.getMaxThreads(), this.config.getThreadTimeoutSecs(), TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(this.config.getThreadQueueSize()), this.createThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected ThreadFactory createThreadFactory() {
        return new GoogleAnalyticsThreadFactory(this.config.getThreadNameFormat());
    }
}

