/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.manalytics;

import de.maggicraft.manalytics.discovery.DefaultRequestParameterDiscoverer;
import de.maggicraft.manalytics.discovery.RequestParameterDiscoverer;

public class GoogleAnalyticsConfig {
    private String threadNameFormat = "googleanalyticsjava-thread-{0}";
    private boolean enabled = true;
    private int minThreads = 0;
    private int maxThreads = 5;
    private int threadTimeoutSecs = 300;
    private int threadQueueSize = 1000;
    private int maxHttpConnectionsPerRoute = 10;
    private boolean useHttps = true;
    private boolean validate = true;
    private boolean batchingEnabled = false;
    private int batchSize = 20;
    private String httpUrl = "http://www.google-analytics.com/collect";
    private String httpsUrl = "https://www.google-analytics.com/collect";
    private String batchUrl = "https://www.google-analytics.com/batch";
    private String userAgent = null;
    private String proxyHost = null;
    private int proxyPort = 80;
    private String proxyUserName = null;
    private String proxyPassword = null;
    private boolean discoverRequestParameters = true;
    private boolean gatherStats = false;
    private RequestParameterDiscoverer requestParameterDiscoverer = new DefaultRequestParameterDiscoverer();

    public RequestParameterDiscoverer getRequestParameterDiscoverer() {
        return this.requestParameterDiscoverer;
    }

    public GoogleAnalyticsConfig setRequestParameterDiscoverer(RequestParameterDiscoverer requestParameterDiscoverer) {
        this.requestParameterDiscoverer = requestParameterDiscoverer;
        return this;
    }

    public boolean isGatherStats() {
        return this.gatherStats;
    }

    public GoogleAnalyticsConfig setGatherStats(boolean gatherStats) {
        this.gatherStats = gatherStats;
        return this;
    }

    public GoogleAnalyticsConfig setThreadNameFormat(String threadNameFormat) {
        this.threadNameFormat = threadNameFormat;
        return this;
    }

    public String getThreadNameFormat() {
        return this.threadNameFormat;
    }

    @Deprecated
    public GoogleAnalyticsConfig setDeriveSystemParameters(boolean deriveSystemProperties) {
        return this.setDiscoverRequestParameters(deriveSystemProperties);
    }

    public GoogleAnalyticsConfig setDiscoverRequestParameters(boolean discoverSystemParameters) {
        this.discoverRequestParameters = discoverSystemParameters;
        return this;
    }

    public boolean isDiscoverRequestParameters() {
        return this.discoverRequestParameters;
    }

    public GoogleAnalyticsConfig setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
        return this;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public GoogleAnalyticsConfig setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public GoogleAnalyticsConfig setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public GoogleAnalyticsConfig setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public GoogleAnalyticsConfig setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GoogleAnalyticsConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public GoogleAnalyticsConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public GoogleAnalyticsConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public GoogleAnalyticsConfig setUseHttps(boolean useHttps) {
        this.useHttps = useHttps;
        return this;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public GoogleAnalyticsConfig setValidate(boolean validate) {
        this.validate = validate;
        return this;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public GoogleAnalyticsConfig setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
        return this;
    }

    public String getHttpsUrl() {
        return this.httpsUrl;
    }

    public GoogleAnalyticsConfig setHttpsUrl(String httpsUrl) {
        this.httpsUrl = httpsUrl;
        return this;
    }

    public String getUrl() {
        return this.useHttps ? this.httpsUrl : this.httpUrl;
    }

    public int getMaxHttpConnectionsPerRoute() {
        return this.maxHttpConnectionsPerRoute;
    }

    public GoogleAnalyticsConfig setMaxHttpConnectionsPerRoute(int maxHttpConnectionsPerRoute) {
        this.maxHttpConnectionsPerRoute = maxHttpConnectionsPerRoute;
        return this;
    }

    public String toString() {
        return "GoogleAnalyticsConfig [threadNameFormat=" + this.threadNameFormat + ", enabled=" + this.enabled + ", minThreads=" + this.minThreads + ", maxThreads=" + this.maxThreads + ", threadTimeoutSecs=" + this.threadTimeoutSecs + ", threadQueueSize=" + this.threadQueueSize + ", maxHttpConnectionsPerRoute=" + this.maxHttpConnectionsPerRoute + ", useHttps=" + this.useHttps + ", validate=" + this.validate + ", httpUrl=" + this.httpUrl + ", httpsUrl=" + this.httpsUrl + ", userAgent=" + this.userAgent + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyUserName=" + this.proxyUserName + ", proxyPassword=" + GoogleAnalyticsConfig.mask(this.proxyPassword) + ", discoverRequestParameters=" + this.discoverRequestParameters + ", gatherStats=" + this.gatherStats + ", requestParameterDiscoverer=" + this.requestParameterDiscoverer + "]";
    }

    public static String mask(String value) {
        return value == null ? null : "********";
    }

    public int getThreadQueueSize() {
        return this.threadQueueSize;
    }

    public GoogleAnalyticsConfig setThreadQueueSize(int threadQueueSize) {
        this.threadQueueSize = threadQueueSize;
        return this;
    }

    public int getThreadTimeoutSecs() {
        return this.threadTimeoutSecs;
    }

    public GoogleAnalyticsConfig setThreadTimeoutSecs(int threadTimeoutSecs) {
        this.threadTimeoutSecs = threadTimeoutSecs;
        return this;
    }

    public String getBatchUrl() {
        return this.batchUrl;
    }

    public GoogleAnalyticsConfig setBatchUrl(String batchUrl) {
        this.batchUrl = batchUrl;
        return this;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public GoogleAnalyticsConfig setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public GoogleAnalyticsConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }
}

