/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.manalytics.discovery;

import de.maggicraft.manalytics.GoogleAnalyticsConfig;
import de.maggicraft.manalytics.discovery.DefaultRequestParameterDiscoverer;
import de.maggicraft.manalytics.internal.GaUtils;
import de.maggicraft.manalytics.request.DefaultRequest;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

public class AwtRequestParameterDiscoverer
extends DefaultRequestParameterDiscoverer {
    @Override
    public DefaultRequest discoverParameters(GoogleAnalyticsConfig config, DefaultRequest request) {
        super.discoverParameters(config, request);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (GaUtils.isEmpty(request.screenResolution())) {
            Dimension screenSize = toolkit.getScreenSize();
            request.screenResolution((int)screenSize.getWidth() + "x" + (int)screenSize.getHeight() + ", " + toolkit.getScreenResolution() + " dpi");
        }
        if (GaUtils.isEmpty(request.screenColors())) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
            StringBuilder sb = new StringBuilder();
            for (GraphicsDevice graphicsDevice : graphicsDevices) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(graphicsDevice.getDisplayMode().getBitDepth());
            }
            request.screenColors(sb.toString());
        }
        return request;
    }
}

