/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.manalytics.discovery;

import de.maggicraft.manalytics.GoogleAnalyticsConfig;
import de.maggicraft.manalytics.discovery.RequestParameterDiscoverer;
import de.maggicraft.manalytics.internal.GaUtils;
import de.maggicraft.manalytics.request.DefaultRequest;
import de.maggicraft.mlog.MLog;

public class DefaultRequestParameterDiscoverer
implements RequestParameterDiscoverer {
    public static final DefaultRequestParameterDiscoverer INSTANCE = new DefaultRequestParameterDiscoverer();

    @Override
    public DefaultRequest discoverParameters(GoogleAnalyticsConfig config, DefaultRequest request) {
        try {
            if (GaUtils.isEmpty(config.getUserAgent())) {
                config.setUserAgent(this.getUserAgentString());
            }
            if (GaUtils.isEmpty(request.userLanguage())) {
                String region = System.getProperty("user.region");
                if (GaUtils.isEmpty(region)) {
                    region = System.getProperty("user.country");
                }
                request.userLanguage(System.getProperty("user.language") + "-" + region);
            }
            if (GaUtils.isEmpty(request.documentEncoding())) {
                request.documentEncoding(System.getProperty("file.encoding"));
            }
        }
        catch (Exception e) {
            MLog.logNoAnalytics("Exception while deriving the System properties for request " + request, e);
        }
        return request;
    }

    protected String getUserAgentString() {
        StringBuilder sb = new StringBuilder("java");
        GaUtils.appendSystemProperty(sb, "java.runtime.version");
        GaUtils.appendSystemProperty(sb, "java.specification.vendor");
        GaUtils.appendSystemProperty(sb, "java.vm.name");
        GaUtils.appendSystemProperty(sb, "os.name");
        GaUtils.appendSystemProperty(sb, "os.version");
        GaUtils.appendSystemProperty(sb, "os.arch");
        return sb.toString();
    }
}

