/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.manalytics.httpclient;

import de.maggicraft.manalytics.GoogleAnalyticsConfig;
import de.maggicraft.manalytics.httpclient.BatchUrlEncodedFormEntity;
import de.maggicraft.manalytics.httpclient.HttpBatchRequest;
import de.maggicraft.manalytics.httpclient.HttpBatchResponse;
import de.maggicraft.manalytics.httpclient.HttpClient;
import de.maggicraft.manalytics.httpclient.HttpRequest;
import de.maggicraft.manalytics.httpclient.HttpResponse;
import de.maggicraft.manalytics.internal.GaUtils;
import de.maggicraft.mlog.MLog;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClientImpl
implements HttpClient {
    private CloseableHttpClient apacheHttpClient;

    public ApacheHttpClientImpl(GoogleAnalyticsConfig config) {
        this.apacheHttpClient = this.createHttpClient(config);
    }

    @Override
    public void close() {
        try {
            this.apacheHttpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected CloseableHttpClient createHttpClient(GoogleAnalyticsConfig config) {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(Math.max(config.getMaxHttpConnectionsPerRoute(), 1));
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(connManager);
        if (GaUtils.isNotEmpty(config.getUserAgent())) {
            builder.setUserAgent(config.getUserAgent());
        }
        if (GaUtils.isNotEmpty(config.getProxyHost())) {
            builder.setProxy(new HttpHost(config.getProxyHost(), config.getProxyPort()));
            if (GaUtils.isNotEmpty(config.getProxyUserName())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(config.getProxyHost(), config.getProxyPort()), new UsernamePasswordCredentials(config.getProxyUserName(), config.getProxyPassword()));
                builder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        return builder.build();
    }

    @Override
    public boolean isBatchSupported() {
        return true;
    }

    protected CloseableHttpResponse execute(String url, HttpEntity entity) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(entity);
        return this.apacheHttpClient.execute(httpPost);
    }

    protected List<NameValuePair> createNameValuePairs(HttpRequest req) {
        ArrayList<NameValuePair> parmas = new ArrayList<NameValuePair>();
        req.getBodyParams().forEach((key, value) -> parmas.add(new BasicNameValuePair((String)key, (String)value)));
        return parmas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse post(HttpRequest req) {
        HttpResponse resp = new HttpResponse();
        org.apache.http.HttpResponse httpResp = null;
        try {
            httpResp = this.execute(req.getUrl(), new UrlEncodedFormEntity(this.createNameValuePairs(req), StandardCharsets.UTF_8));
            resp.setStatusCode(httpResp.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException) {
                MLog.logNoAnalytics("Couldn't connect to Google Analytics. Internet may not be available. " + e);
            } else {
                MLog.logNoAnalytics("Exception while sending the Google Analytics tracker request " + req, e);
            }
        }
        finally {
            EntityUtils.consumeQuietly(httpResp.getEntity());
            try {
                httpResp.close();
            }
            catch (Exception exception) {}
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpBatchResponse postBatch(HttpBatchRequest req) {
        HttpBatchResponse resp = new HttpBatchResponse();
        org.apache.http.HttpResponse httpResp = null;
        try {
            List<List<NameValuePair>> listOfReqPairs = req.getRequests().stream().map(this::createNameValuePairs).collect(Collectors.toList());
            httpResp = this.execute(req.getUrl(), new BatchUrlEncodedFormEntity(listOfReqPairs));
            resp.setStatusCode(httpResp.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException) {
                MLog.logNoAnalytics("Couldn't connect to Google Analytics. Internet may not be available. " + e);
            } else {
                MLog.logNoAnalytics("Exception while sending the Google Analytics tracker request " + req, e);
            }
        }
        finally {
            EntityUtils.consumeQuietly(httpResp.getEntity());
            try {
                httpResp.close();
            }
            catch (Exception exception) {}
        }
        return resp;
    }
}

