/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.event;

import de.maggicraft.mcommons.event.IObserver;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface ITypeObservable<T extends Enum, E> {
    default public Collection<IObserver<E>> defaultCollection() {
        return new LinkedList<IObserver<E>>();
    }

    default public void registerObserver(@NotNull T pType, @NotNull IObserver<E> pObserver) {
        Collection<IObserver<IObserver<E>>> collection = this.getObservers().get(pType);
        if (collection == null) {
            collection = this.defaultCollection();
            this.getObservers().put(pType, collection);
        }
        collection.add(pObserver);
    }

    default public boolean removeObserver(@NotNull T pType, @NotNull IObserver<E> pObserver) {
        Collection<IObserver<E>> observers = this.getObservers().get(pType);
        if (observers == null) {
            return false;
        }
        return observers.remove(pObserver);
    }

    default public void notifyObservers(@NotNull T pType, @NotNull E pEvent) {
        Collection<IObserver<E>> observers = this.getObservers().get(pType);
        if (observers != null) {
            for (IObserver<E> observer : observers) {
                observer.update(pEvent);
            }
        }
    }

    @NotNull
    public Map<T, Collection<IObserver<E>>> getObservers();
}

