/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.filter.types;

import de.maggicraft.mcommons.filter.IFilter;
import de.maggicraft.mcommons.util.CCon;
import org.jetbrains.annotations.NotNull;

public abstract class MFilter
implements IFilter<String> {
    public static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] DIGITS_FLOAT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', '.', 'E'};
    public static final char[] LOWERCASE_ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] LOWERCASE_ALPHABET_EXPANDED = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00fc', '\u00df'};
    public static final char[] ILLEGAL_FILE_NAME = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':', '.', ';'};
    public static final char[] LEGAL_URL_CHARS = new char[]{'1', ' ', '.', 'e', 'i', '0', 'r', 's', ';', 'a', 't', 'o', '2', 'n', '3', 'm', 'c', '8', 'l', 'd', '5', 'u', 'p', '7', '4', '-', 'v', '6', 'S', '9', 'g', 'y', 'h', '(', ')', 'T', 'M', 'H', 'f', ',', 'F', 'A', 'w', 'C', 'b', 'B', 'k', 'W', 'D', 'P', 'L', 'j', '/', 'V', 'G', 'J', 'R', 'z', 'E', 'O', 'I', 'x', 'Q', 'N', 'q', ':', 'U', 'Z', 'K', 'X', 'Y', '_', '~', '?', '#', '[', ']', '@', '!', '$', '&', '\'', '*', '+', '=', '%'};
    public static final boolean INCLUSIVE = true;
    public static final boolean EXCLUSIVE = false;

    public static boolean isInteger(@NotNull String pStr, int pMin, int pMax) {
        if (MFilter.isInteger(pStr, 10)) {
            try {
                int value = Integer.parseInt(pStr);
                return value >= pMin && value <= pMax;
            }
            catch (NumberFormatException pE) {
                return false;
            }
        }
        return false;
    }

    public static boolean isInteger(@NotNull String pStr) {
        boolean valid = MFilter.isInteger(pStr, 10);
        if (pStr.length() >= 10 && valid) {
            try {
                Integer.parseInt(pStr);
            }
            catch (NumberFormatException pE) {
                return false;
            }
        }
        return valid;
    }

    public static boolean isLong(@NotNull String pStr) {
        boolean valid = MFilter.isInteger(pStr, 19);
        if (pStr.length() >= 19 && valid) {
            try {
                Long.parseLong(pStr);
            }
            catch (NumberFormatException pE) {
                return false;
            }
        }
        return valid;
    }

    private static boolean isInteger(@NotNull String pStr, int pLength) {
        if (pStr.isEmpty()) {
            return false;
        }
        char ch = pStr.charAt(0);
        int i = ch == '+' || ch == '-' ? 1 : 0;
        return i != pStr.length() && pStr.length() <= pLength + i && MFilter.existOf(pStr, DIGITS, i);
    }

    public static boolean isFloat(@NotNull String pStr) {
        if (!MFilter.existOf(pStr, DIGITS_FLOAT, 0)) {
            return false;
        }
        try {
            Float.parseFloat(pStr);
            return true;
        }
        catch (NumberFormatException pE) {
            return false;
        }
    }

    public static boolean isDouble(@NotNull String pStr) {
        if (!MFilter.existOf(pStr, DIGITS_FLOAT, 0)) {
            return false;
        }
        try {
            Double.parseDouble(pStr);
            return true;
        }
        catch (NumberFormatException pE) {
            return false;
        }
    }

    public static boolean isFilename(@NotNull String pStr) {
        return MFilter.isValid(pStr, ILLEGAL_FILE_NAME, false);
    }

    public static boolean isURL(@NotNull String pStr) {
        return MFilter.isValid(pStr, LEGAL_URL_CHARS, true);
    }

    public static boolean isLength(@NotNull String pStr, int pLength) {
        return pStr.length() <= pLength;
    }

    @NotNull
    public static String validateInteger(@NotNull String pStr, int pMin, int pMax) {
        String num = MFilter.validateInteger(pStr);
        try {
            int i;
            while (!num.isEmpty() && ((i = Integer.parseInt(num)) > 0 && i > pMax || i < 0 && i < pMin)) {
                num = num.substring(0, num.length() - 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    @NotNull
    public static String validateInteger(@NotNull String pStr) {
        boolean iterate;
        String valid = MFilter.validateInteger(pStr, 10);
        boolean bl = iterate = valid.length() >= 10;
        while (iterate) {
            try {
                Integer.parseInt(valid);
                return valid;
            }
            catch (NumberFormatException pE) {
                valid = valid.substring(0, valid.length() - 1);
                iterate = valid.length() >= 10;
            }
        }
        return valid;
    }

    @NotNull
    public static String validateLong(@NotNull String pStr) {
        boolean iterate;
        String valid = MFilter.validateInteger(pStr, 19);
        boolean bl = iterate = valid.length() >= 10;
        while (iterate) {
            try {
                Long.parseLong(valid);
                return valid;
            }
            catch (NumberFormatException pE) {
                valid = valid.substring(0, valid.length() - 1);
                iterate = valid.length() >= 10;
            }
        }
        return valid;
    }

    private static String validateInteger(@NotNull String pStr, int pLength) {
        if (pStr.isEmpty()) {
            return "";
        }
        StringBuilder valid = new StringBuilder();
        char ch = pStr.charAt(0);
        int i = 0;
        if (ch == '+' || ch == '-') {
            ++pLength;
            valid.append(ch);
            i = 1;
        }
        while (i < pStr.length() && i < pLength) {
            ch = pStr.charAt(i);
            if (MFilter.contains(DIGITS, ch)) {
                valid.append(ch);
            } else {
                ++pLength;
            }
            ++i;
        }
        return valid.toString();
    }

    public static String validateFloat(@NotNull String pStr) {
        return MFilter.validate(pStr, DIGITS_FLOAT, true);
    }

    public static String validateDouble(@NotNull String pStr) {
        return MFilter.validate(pStr, DIGITS_FLOAT, true);
    }

    public static String validateFilename(@NotNull String pStr) {
        return MFilter.validate(pStr, ILLEGAL_FILE_NAME, false);
    }

    public static String validateURL(@NotNull String pStr) {
        return MFilter.validate(pStr, LEGAL_URL_CHARS, true);
    }

    @NotNull
    public static String validatePath(String pStr) {
        throw CCon.NOT_SUPPORTED;
    }

    @NotNull
    public static String validateLength(@NotNull String pStr, int pLength) {
        if (pStr.length() > pLength) {
            return pStr.substring(0, pLength);
        }
        return pStr;
    }

    public static boolean isValid(@NotNull String pStr, @NotNull char[] pChars, boolean pInclusive) {
        for (int i = 0; i < pStr.length(); ++i) {
            if (MFilter.contains(pChars, pStr.charAt(i)) == pInclusive) continue;
            return false;
        }
        return true;
    }

    public static String validate(@NotNull String pStr, @NotNull char[] pChars, boolean pInclusive) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < pStr.length(); ++i) {
            if (MFilter.contains(pChars, pStr.charAt(i)) != pInclusive) continue;
            res.append(pStr.charAt(i));
        }
        return res.toString();
    }

    private static boolean existOf(@NotNull String pStr, @NotNull char[] pCharacters, int pI) {
        while (pI < pStr.length()) {
            if (!MFilter.contains(pCharacters, pStr.charAt(pI))) {
                return false;
            }
            ++pI;
        }
        return true;
    }

    public static boolean contains(@NotNull char[] pCharacters, char pChar) {
        for (char character : pCharacters) {
            if (character != pChar) continue;
            return true;
        }
        return false;
    }
}

