/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.filter.types;

import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import org.jetbrains.annotations.NotNull;

public final class MFilters {
    public static final MFilter FILTER_NUMERIC = new MFilter(){

        @Override
        public boolean isValid(@NotNull String pStr) {
            return 1.isValid(pStr, DIGITS, true);
        }

        @Override
        public String validate(@NotNull String pStr) {
            return 1.validate(pStr, DIGITS, true);
        }

        @Override
        @NotNull
        public String desc() {
            return "";
        }
    };
    public static final MFilter FILTER_INTEGER = new MFilter(){

        @Override
        public boolean isValid(@NotNull String pStr) {
            return 2.isInteger(pStr);
        }

        @Override
        @NotNull
        public String validate(@NotNull String pStr) {
            return 2.validateInteger(pStr);
        }

        @Override
        @NotNull
        public String desc() {
            return "";
        }
    };
    public static final MFilter FILTER_LONG = new MFilter(){

        @Override
        public boolean isValid(@NotNull String pStr) {
            return 3.isLong(pStr);
        }

        @Override
        @NotNull
        public String validate(@NotNull String pStr) {
            return 3.validateLong(pStr);
        }

        @Override
        @NotNull
        public String desc() {
            return "";
        }
    };
    public static final MFilter FILTER_FLOAT = new MFilter(){

        @Override
        public boolean isValid(@NotNull String pStr) {
            return 4.isFloat(pStr);
        }

        @Override
        public String validate(@NotNull String pStr) {
            return 4.validateFloat(pStr);
        }

        @Override
        @NotNull
        public String desc() {
            return "";
        }
    };
    public static final MFilter FILTER_DOUBLE = new MFilter(){

        @Override
        public boolean isValid(@NotNull String pStr) {
            return 5.isDouble(pStr);
        }

        @Override
        public String validate(@NotNull String pStr) {
            return 5.validateDouble(pStr);
        }

        @Override
        @NotNull
        public String desc() {
            return "";
        }
    };
    public static final MFilter FILTER_FILENAME = new MFilter(){

        @Override
        public boolean isValid(@NotNull String pStr) {
            return 6.isFilename(pStr);
        }

        @Override
        public String validate(@NotNull String pStr) {
            return 6.validateFilename(pStr);
        }

        @Override
        @NotNull
        public String desc() {
            return MLangManager.get("hi.fileName");
        }
    };
    public static final MFilter FILTER_URL = new MFilter(){

        @Override
        public boolean isValid(@NotNull String pStr) {
            return 7.isURL(pStr);
        }

        @Override
        public String validate(@NotNull String pStr) {
            return 7.validateURL(pStr);
        }

        @Override
        @NotNull
        public String desc() {
            return MLangManager.get("hi.url");
        }
    };
    public static final MFilter FILTER_EMPTY = new MFilter(){

        @Override
        public String validate(String pValue) {
            return pValue;
        }

        @Override
        public boolean isValid(String pValue) {
            return pValue.isEmpty();
        }

        @Override
        @NotNull
        public String desc() {
            return "";
        }
    };

    private MFilters() {
    }

    public static MFilter filterLength(final int pLength) {
        return new MFilter(){

            @Override
            public boolean isValid(@NotNull String pStr) {
                return 9.isLength(pStr, pLength);
            }

            @Override
            @NotNull
            public String validate(@NotNull String pStr) {
                return 9.validateLength(pStr, pLength);
            }

            @Override
            @NotNull
            public String desc() {
                return "";
            }
        };
    }

    public static MFilter filterInt(final int pMin, final int pMax) {
        return new MFilter(){

            @Override
            public boolean isValid(@NotNull String pStr) {
                return 10.isInteger(pStr, pMin, pMax);
            }

            @Override
            @NotNull
            public String validate(@NotNull String pStr) {
                return 10.validateInteger(pStr, pMin, pMax);
            }

            @Override
            @NotNull
            public String desc() {
                return MLangManager.get("hi.intRange").replaceAll("%0", CommonUtil.decMark(pMin)).replace("%1", CommonUtil.decMark(pMax));
            }
        };
    }
}

