/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.initialization;

import de.maggicraft.mcommons.initialization.EInitializableStates;
import de.maggicraft.mcommons.initialization.IInitializable;
import de.maggicraft.mcommons.state_machine.IStateMachine;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mlog.MLog;
import de.maggicraft.mthread.MLock;
import org.jetbrains.annotations.NotNull;

public class MLazy
implements IStateMachine<EInitializableStates> {
    private static final boolean LOG = false;
    private static int sInitCount;
    @NotNull
    private final MLock mLock = new MLock();
    private MLazy[] mRequired;
    private IInitializable mInitializable;
    @NotNull
    private EInitializableStates mState = EInitializableStates.NOT_STARTED;
    private String mName;
    private long mInitTime;

    protected MLazy() {
    }

    public MLazy(@NotNull IInitializable pInitializable) {
        this(pInitializable, MLazy.standardName(), new MLazy[0]);
    }

    public MLazy(@NotNull IInitializable pInitializable, @NotNull String pName) {
        this(pInitializable, pName, new MLazy[0]);
    }

    public MLazy(@NotNull IInitializable pInitializable, MLazy ... pRequired) {
        this(pInitializable, MLazy.standardName(), pRequired);
    }

    public MLazy(@NotNull IInitializable pInitializable, @NotNull String pName, MLazy ... pRequired) {
        this.mInitializable = pInitializable;
        this.mName = pName;
        this.mRequired = pRequired;
    }

    @NotNull
    protected static String standardName() {
        return "lazy-init: " + ++sInitCount;
    }

    protected static boolean hasLogger() {
        return MLog.getLog() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initLazy() {
        try {
            if (this.mLock.enter()) {
                return;
            }
            long timeTotal = System.currentTimeMillis();
            for (MLazy require : this.mRequired) {
                require.initLazy();
            }
            this.mState = EInitializableStates.INITIALIZING;
            long time = System.currentTimeMillis();
            this.mInitializable.initialize();
            this.mInitTime = System.currentTimeMillis() - time;
            timeTotal = System.currentTimeMillis() - timeTotal;
            this.mState = EInitializableStates.INITIALIZED;
        }
        catch (Exception pE) {
            this.log(pE);
            this.mState = EInitializableStates.FAILED;
        }
        finally {
            this.mLock.leave();
        }
    }

    protected void log(@NotNull Exception pE) {
        if (MLazy.hasLogger()) {
            MLog.log("LazyInit " + this.mName + " failed: ", pE);
        } else {
            System.err.println(this.mName + " - failed");
            pE.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MLazy lazy : this.mRequired) {
            sb.append(this.mName).append(" --> ").append(lazy.mName).append(CCon.LINE_SEP);
        }
        return sb.toString();
    }

    protected void setRequired(MLazy ... pRequired) {
        this.mRequired = pRequired;
    }

    protected void setInitializable(@NotNull IInitializable pInitializable) {
        this.mInitializable = pInitializable;
    }

    public long getInitTime() {
        return this.mInitTime;
    }

    protected void setInitTime(long pInitTime) {
        this.mInitTime = pInitTime;
    }

    @NotNull
    public String getName() {
        return this.mName;
    }

    protected void setName(@NotNull String pName) {
        this.mName = pName;
    }

    @Override
    @NotNull
    public EInitializableStates getState() {
        return this.mState;
    }
}

