/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.lang;

import de.maggicraft.mcommons.lang.ILang;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mlog.MLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MLang
implements ILang {
    @NotNull
    private final ResourceBundle mBundle;
    @Nullable
    private ILang mBackUp;

    public MLang(@NotNull ResourceBundle pBundle) {
        this.mBundle = pBundle;
    }

    public MLang(@NotNull ResourceBundle pBundle, @Nullable ILang pBackUp) {
        this.mBundle = pBundle;
        this.mBackUp = pBackUp;
    }

    public static Optional<PropertyResourceBundle> makeBundle(@NotNull URL pURL) {
        try {
            return Optional.of(new PropertyResourceBundle(new InputStreamReader(pURL.openStream())));
        }
        catch (IOException pE) {
            MLog.log("failed to load PropertyResourceBundle from url \"" + pURL.getPath() + '\"', pE);
            return Optional.empty();
        }
    }

    public static Optional<PropertyResourceBundle> makeBundle(@NotNull InputStream pStream) {
        try {
            return Optional.of(new PropertyResourceBundle(pStream));
        }
        catch (IOException pE) {
            MLog.log("failed to load PropertyResourceBundle from given stream \"" + pStream + '\"', pE);
            return Optional.empty();
        }
    }

    private static void checkRep(@NotNull String pKey, @NotNull String pText, int pExpectedQuantity) throws IllegalArgumentException {
        int actualQuantity = 0;
        for (int i = 0; i < pText.length(); ++i) {
            if (pText.charAt(i) != '%') continue;
            ++actualQuantity;
        }
        if (actualQuantity != pExpectedQuantity) {
            StringBuilder sb = new StringBuilder().append("the text \"").append(pText).append("\" for key \"").append(pKey).append("\" contains ").append(actualQuantity).append(" parameters but ").append(pExpectedQuantity).append(" were expected");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @Override
    @NotNull
    public String get(@NotNull String pKey) {
        try {
            return this.mBundle.getString(pKey);
        }
        catch (MissingResourceException pE) {
            if (this.mBackUp == null) {
                System.out.println("stacktrace");
                CommonUtil.stacktrace("missing key");
                System.out.println("own:");
                MLog.log("missing key \"" + pKey + "\" in " + this.mBundle.getBaseBundleName());
                System.out.println("default:");
                MLog.log(pE);
                return pKey;
            }
            return this.mBackUp.get(pKey);
        }
    }

    @Override
    @NotNull
    public String[] get(String ... pKeys) {
        String[] texts = new String[pKeys.length];
        for (int i = 0; i < texts.length; ++i) {
            texts[i] = this.get(pKeys[i]);
        }
        return texts;
    }

    @Override
    @NotNull
    public String[] prefix(@NotNull String pPrefix, String ... pKeys) {
        String[] prefixed = new String[pKeys.length];
        for (int i = 0; i < prefixed.length; ++i) {
            prefixed[i] = this.get(pPrefix + pKeys[i]);
        }
        return prefixed;
    }

    @Override
    @NotNull
    public String rep(@NotNull String pKey, Object ... pReplace) throws IllegalArgumentException {
        String text = this.get(pKey);
        MLang.checkRep(pKey, text, pReplace.length);
        for (int i = 0; i < pReplace.length; ++i) {
            text = text.replace("%" + i, pReplace[i].toString());
        }
        return text;
    }
}

